/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.armor.ModArmorMaterial;
import com.pekar.angelblock.utils.Utils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class FlyingArmor
extends ModArmor {
    protected FlyingArmor(ModArmorMaterial material, ArmorItem.Type equipmentSlot) {
        super(material, equipmentSlot);
    }

    @Override
    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        if (this.type != ArmorItem.Type.CHESTPLATE) {
            return false;
        }
        if (entity.hasEffect(MobEffects.SLOW_FALLING)) {
            return false;
        }
        if (Utils.instance.dimension.isNether((ResourceKey<Level>)entity.level().dimension()) || entity.isInWaterRainOrBubble()) {
            return false;
        }
        ItemStack mainHandItemStack = entity.getMainHandItem();
        if (mainHandItemStack.is(Items.FIREWORK_ROCKET)) {
            return false;
        }
        ItemStack offHandItemStack = entity.getOffhandItem();
        if (offHandItemStack.is(Items.FIREWORK_ROCKET)) {
            return false;
        }
        boolean isFlyingHelmet = this.getModelName(entity, EquipmentSlot.HEAD).equals(((ModArmor)ArmorRegistry.FLYING_HELMET.get()).getArmorFamilyName());
        boolean isFlyingLeggings = this.getModelName(entity, EquipmentSlot.LEGS).equals(((ModArmor)ArmorRegistry.FLYING_LEGGINGS.get()).getArmorFamilyName());
        boolean isFlyingBoots = this.getModelName(entity, EquipmentSlot.FEET).equals(((ModArmor)ArmorRegistry.FLYING_BOOTS.get()).getArmorFamilyName());
        boolean isFlyingChestplate = this.getModelName(entity, EquipmentSlot.CHEST).equals(((ModArmor)ArmorRegistry.FLYING_CHESTPLATE.get()).getArmorFamilyName());
        int maxDamageToFly = stack.getMaxDamage() / 2;
        int chestDamage = stack.getDamageValue();
        boolean isFullArmorSetPutOn = isFlyingBoots && isFlyingLeggings && isFlyingChestplate && isFlyingHelmet;
        return isFullArmorSetPutOn && chestDamage < maxDamageToFly;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return this.canElytraFly(stack, entity);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return this.getModelName(wearer, EquipmentSlot.FEET).equals(((ModArmor)ArmorRegistry.FLYING_BOOTS.get()).getArmorFamilyName());
    }

    private String getModelName(LivingEntity entity, EquipmentSlot slot) {
        Item item = entity.getItemBySlot(slot).getItem();
        if (!(item instanceof ModArmor)) {
            return "";
        }
        ModArmor armorItem = (ModArmor)item;
        return armorItem.getArmorFamilyName();
    }
}

