/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks;

import com.mojang.serialization.MapCodec;
import com.pekar.angelblock.blocks.ModFallingBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GunpowderBlock
extends ModFallingBlock {
    private static final MapCodec<GunpowderBlock> CODEC = GunpowderBlock.simpleCodec(GunpowderBlock::new);

    public GunpowderBlock() {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).sound(SoundType.SNOW).strength(0.2f));
    }

    public GunpowderBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 10000;
    }

    public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void fallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(level, blockState, pos, entity, fallDistance);
        this.fireAndExplode(level, entity);
    }

    private void fireAndExplode(Level level, Entity entity) {
        entity.displayFireAnimation();
        this.explodeBlock(level, new BlockPos(entity.getBlockX(), entity.getBlockY(), entity.getBlockZ()));
    }

    private void explodeBlock(Level level, BlockPos pos) {
        level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.8f, true, Level.ExplosionInteraction.BLOCK);
    }

    public void onLand(Level level, BlockPos pos, BlockState blockState, BlockState blockState1, FallingBlockEntity fallingBlockEntity) {
        this.fireAndExplode(level, (Entity)fallingBlockEntity);
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction direction, @Nullable LivingEntity igniter) {
        this.explodeBlock(level, pos);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 300;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)this.getDisplayName().withStyle(ChatFormatting.DARK_GRAY));
    }

    private MutableComponent getDisplayName() {
        return Component.translatable((String)(this.getDescriptionId() + ".desc"));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }
}

