/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.events.IEventHandler;
import com.pekar.angelblock.events.IPlayerManager;
import com.pekar.angelblock.events.PlayerManager;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.tools.IModTool;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class PlayerDataEvents
implements IEventHandler {
    private final IPlayerManager playerBasic = PlayerManager.instance();

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        IPlayer player;
        Object object;
        Player entityPlayer = event.getEntity();
        ItemStack mainHandItem = entityPlayer.getMainHandItem();
        if (!mainHandItem.isEmpty() && (object = mainHandItem.getItem()) instanceof IModTool) {
            IModTool modTool = (IModTool)object;
            if (modTool.hasExtraLowEfficiencyDurability(mainHandItem)) {
                event.setNewSpeed(event.getNewSpeed() * 0.2f);
            } else if (modTool.hasLowEfficiencyDurability(mainHandItem)) {
                event.setNewSpeed(event.getNewSpeed() * 0.5f);
            }
        }
        if ((player = this.playerBasic.getPlayerByUUID(event.getEntity().getUUID())) == null) {
            return;
        }
        for (IArmor armor : player.getArmorTypesUsed()) {
            armor.onBreakSpeed(event);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (event.getCrafting().is(((Block)BlockRegistry.DEVIL_BLOCK.get()).asItem())) {
            player.level().playSound(null, player.blockPosition(), SoundEvents.WARDEN_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (event.getCrafting().is(((Block)BlockRegistry.ANGEL_BLOCK.get()).asItem())) {
            player.level().playSound(null, player.blockPosition(), SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

