/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.player;

import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.armor.DiamithicArmor;
import com.pekar.angelblock.events.armor.FlyingArmor;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.armor.LapisArmor;
import com.pekar.angelblock.events.armor.LimoniteArmor;
import com.pekar.angelblock.events.armor.RendelithicArmor;
import com.pekar.angelblock.events.armor.SuperArmor;
import com.pekar.angelblock.events.effect.ITemporaryBaseArmorEffect;
import com.pekar.angelblock.events.player.IModMobEffectInstance;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.events.player.ModMobEffectInstance;
import com.pekar.angelblock.network.packets.HoldingAngelRodPacket;
import com.pekar.angelblock.tools.ToolRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Player
implements IPlayer {
    private final IArmor rendelithicArmorModel = new RendelithicArmor(this);
    private final IArmor diamithicArmorModel = new DiamithicArmor(this);
    private final IArmor lapisArmorModel = new LapisArmor(this);
    private final IArmor superArmorModel = new SuperArmor(this);
    private final IArmor limoniteArmorModel = new LimoniteArmor(this);
    private final IArmor flyingArmorModel = new FlyingArmor(this);
    private net.minecraft.world.entity.player.Player entity;
    private final Set<IArmor> armorInUse = ConcurrentHashMap.newKeySet();

    public Player(net.minecraft.world.entity.player.Player entity) {
        this.entity = entity;
    }

    @Override
    public Iterable<IArmor> getArmorTypesUsed() {
        return this.armorInUse;
    }

    @Override
    public boolean isArmorElementPutOn(IArmor armor, EquipmentSlot equipmentSlot) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(equipmentSlot);
        if (itemStack.isEmpty()) {
            return false;
        }
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        return armor.getFamilyName().equals(armorItem.getArmorFamilyName());
    }

    @Override
    public boolean isFullArmorSetPutOn(IArmor armor) {
        Collection<String> armorNamesPutOn = this.getSlotArmorNames();
        List armorStacks = (List)this.getEntity().getArmorSlots();
        return armorNamesPutOn.stream().allMatch(x -> x.equals(armor.getFamilyName())) && armorStacks.stream().allMatch(s -> {
            ModArmor a;
            Item patt0$temp;
            return !s.isEmpty() && (patt0$temp = s.getItem()) instanceof ModArmor && !(a = (ModArmor)patt0$temp).isBroken((ItemStack)s);
        });
    }

    @Override
    public boolean isAllArmorElementsPutOn(IArmor armor, EquipmentSlot ... equipmentSlots) {
        for (EquipmentSlot slot : equipmentSlots) {
            ModArmor armorItem;
            ItemStack itemStack = this.getEntity().getItemBySlot(slot);
            if (itemStack.isEmpty()) {
                return false;
            }
            Item item = itemStack.getItem();
            if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
                return false;
            }
            if (armor.getFamilyName().equals(armorItem.getArmorFamilyName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAnyArmorElementPutOn(IArmor armor) {
        for (ItemStack itemStack : this.getEntity().getArmorSlots()) {
            ModArmor armorItem;
            Item item;
            if (itemStack.isEmpty() || !((item = itemStack.getItem()) instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack) || !armor.getFamilyName().equals(armorItem.getArmorFamilyName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnyArmorElementInclBrokenPutOn(IArmor armor) {
        for (ItemStack itemStack : this.getEntity().getArmorSlots()) {
            Item item;
            if (itemStack.isEmpty() || !((item = itemStack.getItem()) instanceof ModArmor)) continue;
            ModArmor armorItem = (ModArmor)item;
            if (!armor.getFamilyName().equals(armorItem.getArmorFamilyName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHelmetModifiedWithDetector(IArmor armor) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(EquipmentSlot.HEAD);
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        if (!this.areTheSameFamily(armor, armorItem)) {
            return false;
        }
        return armorItem.isModifiedWithDetector();
    }

    @Override
    public boolean isHelmetModifiedWithNightVision(IArmor armor) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(EquipmentSlot.HEAD);
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        if (!this.areTheSameFamily(armor, armorItem)) {
            return false;
        }
        return armorItem.isModifiedWithNightVision();
    }

    @Override
    public boolean areLeggingsModifiedWithHealthRegenerator(IArmor armor) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(EquipmentSlot.LEGS);
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        if (!this.areTheSameFamily(armor, armorItem)) {
            return false;
        }
        return armorItem.isModifiedWithHealthRegenerator();
    }

    @Override
    public boolean areBootsModifiedWithJumpBooster(IArmor armor) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(EquipmentSlot.FEET);
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        if (!this.areTheSameFamily(armor, armorItem)) {
            return false;
        }
        return armorItem.isModifiedWithJumpBooster();
    }

    @Override
    public boolean isChestPlateModifiedWithStrengthBooster(IArmor armor) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(EquipmentSlot.CHEST);
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        if (!this.areTheSameFamily(armor, armorItem)) {
            return false;
        }
        return armorItem.isModifiedWithStrengthBooster();
    }

    @Override
    public boolean isChestPlateModifiedWithSlowFalling(IArmor armor) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(EquipmentSlot.CHEST);
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        if (!this.areTheSameFamily(armor, armorItem)) {
            return false;
        }
        return armorItem.isModifiedWithSlowFalling();
    }

    @Override
    public boolean isChestPlateModifiedWithLuck(IArmor armor) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(EquipmentSlot.CHEST);
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        if (!this.areTheSameFamily(armor, armorItem)) {
            return false;
        }
        return armorItem.isModifiedWithLuck();
    }

    @Override
    public boolean areBootsModifiedWithSeaPower(IArmor armor) {
        ModArmor armorItem;
        ItemStack itemStack = this.getEntity().getItemBySlot(EquipmentSlot.FEET);
        Item item = itemStack.getItem();
        if (!(item instanceof ModArmor) || (armorItem = (ModArmor)item).isBroken(itemStack)) {
            return false;
        }
        if (!this.areTheSameFamily(armor, armorItem)) {
            return false;
        }
        return armorItem.isModifiedWithSeaPower();
    }

    private boolean areTheSameFamily(IArmor armor, ModArmor model) {
        return model.getArmorFamilyName().equals(armor.getFamilyName());
    }

    @Override
    public void updateArmorUsed() {
        this.armorInUse.clear();
        for (ModArmor armor : this.getSlotArmorItems()) {
            IArmor armorModel = this.getArmorModel(armor);
            if (armorModel == null) continue;
            this.armorInUse.add(armorModel);
        }
    }

    @Override
    public boolean isEffectActive(Holder<MobEffect> effect) {
        return this.entity.hasEffect(effect);
    }

    @Override
    public boolean hasArmorEffect(Holder<MobEffect> effect) {
        ModMobEffectInstance modMobEffectInstance;
        MobEffectInstance effectInstance = this.entity.getEffect(effect);
        if (effectInstance instanceof ModMobEffectInstance && (modMobEffectInstance = (ModMobEffectInstance)effectInstance).isCrystalEffect()) {
            return false;
        }
        return effectInstance != null && (!effectInstance.isVisible() || effectInstance.isInfiniteDuration());
    }

    @Override
    public boolean hasAnotherEffect(Holder<MobEffect> effect) {
        MobEffectInstance effectInstance = this.entity.getEffect(effect);
        return effectInstance != null && effectInstance.isVisible();
    }

    @Override
    public IModMobEffectInstance setEffect(Holder<MobEffect> effect, int amplifier) {
        return this.setEffect(effect, -1, amplifier);
    }

    @Override
    public IModMobEffectInstance setEffect(Holder<MobEffect> effect, int amplifier, boolean showIcon) {
        return this.setEffect(effect, -1, amplifier, showIcon);
    }

    @Override
    public IModMobEffectInstance setEffect(Holder<MobEffect> effect, int duration, int amplifier) {
        return this.setEffect(effect, duration, amplifier, false);
    }

    @Override
    public IModMobEffectInstance setEffect(Holder<MobEffect> effect, int duration, int amplifier, boolean showIcon) {
        ModMobEffectInstance effectInstance = new ModMobEffectInstance(effect, duration, amplifier, false, false, showIcon, false);
        this.entity.addEffect((MobEffectInstance)effectInstance);
        return effectInstance;
    }

    @Override
    public IModMobEffectInstance setCrystalEffect(Holder<MobEffect> effect, int duration, int amplifier, boolean showIcon) {
        ModMobEffectInstance effectInstance = new ModMobEffectInstance(effect, duration, amplifier, false, false, showIcon, true);
        this.entity.addEffect((MobEffectInstance)effectInstance);
        return effectInstance;
    }

    @Override
    public IModMobEffectInstance setEffect(ITemporaryBaseArmorEffect armorEffect, int duration, int amplifier) {
        return this.setEffect(armorEffect, duration, amplifier, false);
    }

    @Override
    public IModMobEffectInstance setEffect(ITemporaryBaseArmorEffect armorEffect, int duration, int amplifier, boolean showIcon) {
        ModMobEffectInstance effectInstance = new ModMobEffectInstance(armorEffect.getEffect(), duration, amplifier, false, false, showIcon, false, armorEffect::onDurationEnd);
        this.entity.addEffect((MobEffectInstance)effectInstance);
        return effectInstance;
    }

    @Override
    public MobEffectInstance getEffectInstance(Holder<MobEffect> effect) {
        return this.getEntity().getEffect(effect);
    }

    @Override
    public void clearEffect(Holder<MobEffect> effect) {
        this.entity.removeEffect(effect);
    }

    @Override
    public String getPlayerName() {
        return this.entity.getName().getString();
    }

    @Override
    public net.minecraft.world.entity.player.Player getEntity() {
        return this.entity;
    }

    @Override
    public boolean isOverworld() {
        return this.entity.level().dimension().location().equals((Object)Level.OVERWORLD.location());
    }

    @Override
    public boolean isNether() {
        return this.entity.level().dimension().location().equals((Object)Level.NETHER.location());
    }

    @Override
    public boolean isEnd() {
        return this.entity.level().dimension().location().equals((Object)Level.END.location());
    }

    @Override
    public void updateEntity(net.minecraft.world.entity.player.Player entity) {
        this.entity = entity;
    }

    @Override
    public void sendMessage(String message) {
        System.out.println(message);
    }

    @Override
    public void onClientTick() {
        if (this.generatePacketIfHoldsAngel(this.entity.getMainHandItem())) {
            return;
        }
        this.generatePacketIfHoldsAngel(this.entity.getOffhandItem());
    }

    private Collection<String> getSlotArmorNames() {
        Iterable itemStacks = this.entity.getArmorSlots();
        HashSet<String> armorNames = new HashSet<String>();
        for (ItemStack itemStack : itemStacks) {
            Item item = itemStack.getItem();
            if (item instanceof ModArmor) {
                ModArmor armorItem = (ModArmor)item;
                String name = armorItem.getArmorFamilyName();
                armorNames.add(name);
                continue;
            }
            armorNames.add(item.getName(itemStack).getString());
        }
        return armorNames;
    }

    private Collection<ModArmor> getSlotArmorItems() {
        Iterable itemStacks = this.entity.getArmorSlots();
        ArrayList<ModArmor> armorItems = new ArrayList<ModArmor>();
        for (ItemStack itemStack : itemStacks) {
            Item item = itemStack.getItem();
            if (!(item instanceof ModArmor)) continue;
            ModArmor armorItem = (ModArmor)item;
            armorItems.add(armorItem);
        }
        return armorItems;
    }

    private IArmor getArmorModel(ModArmor modArmor) {
        String modelName = modArmor.getArmorFamilyName();
        if (modelName.equals(this.rendelithicArmorModel.getFamilyName())) {
            return this.rendelithicArmorModel;
        }
        if (modelName.equals(this.diamithicArmorModel.getFamilyName())) {
            return this.diamithicArmorModel;
        }
        if (modelName.equals(this.lapisArmorModel.getFamilyName())) {
            return this.lapisArmorModel;
        }
        if (modelName.equals(this.superArmorModel.getFamilyName())) {
            return this.superArmorModel;
        }
        if (modelName.equals(this.limoniteArmorModel.getFamilyName())) {
            return this.limoniteArmorModel;
        }
        if (modelName.equals(this.flyingArmorModel.getFamilyName())) {
            return this.flyingArmorModel;
        }
        return null;
    }

    private boolean generatePacketIfHoldsAngel(ItemStack handItemStack) {
        if (handItemStack.isEmpty()) {
            return false;
        }
        Item item = handItemStack.getItem();
        if (item != ToolRegistry.ANGEL_ROD.get()) {
            return false;
        }
        new HoldingAngelRodPacket().sendToServer();
        return true;
    }
}

