/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.items;

import com.pekar.angelblock.items.ModItemWithDoubleHoverText;
import com.pekar.angelblock.potions.PotionRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BiosDiamond
extends ModItemWithDoubleHoverText {
    private static final int COOLDOWN_TIME = 100;

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        if (!player.hasEffect(MobEffects.ABSORPTION) && !player.hasEffect(PotionRegistry.BIOS_DIAMOND_COOLDOWN_EFFECT)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int duration = level.getRandom().nextIntBetweenInclusive(40, 200);
                int effectLevel = level.getRandom().nextIntBetweenInclusive(0, 4);
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, duration, effectLevel, true, true));
                player.addEffect(new MobEffectInstance(PotionRegistry.BIOS_DIAMOND_COOLDOWN_EFFECT, duration + 100, 0, true, false, true));
            }
            this.utils.sound.playSound(player, player.blockPosition(), SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 1.0f, 2.0f);
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(interactionHand), (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.utils.text.showExtendedDescription(tooltipComponents)) {
            return;
        }
        for (int i = 1; i <= 3; ++i) {
            MutableComponent component = this.getDisplayName(i).withStyle(ChatFormatting.GRAY);
            if (i == 2) {
                component.withStyle(ChatFormatting.ITALIC);
            }
            if (i == 3) {
                component.withStyle(ChatFormatting.DARK_GREEN);
            }
            tooltipComponents.add((Component)component);
        }
    }
}

