/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.ModPickaxe;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class EnhancedPickaxe
extends ModPickaxe {
    public EnhancedPickaxe(Tier material, int attackDamage, float attackSpeed, Item.Properties properties, IMaterialProperties materialProperties) {
        super(material, attackDamage, attackSpeed, properties, materialProperties);
    }

    @Override
    public boolean isEnhanced() {
        return true;
    }

    public boolean mineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos pos, LivingEntity livingEntity) {
        if (!level.isClientSide) {
            this.mineAdditionalBlocks(level, pos, livingEntity);
        }
        return super.mineBlock(itemStack, level, blockState, pos, livingEntity);
    }

    protected void mineAdditionalBlocks(Level level, BlockPos pos, LivingEntity entityLiving) {
        int b;
        int a;
        if (!this.isToolEffective(entityLiving, pos)) {
            return;
        }
        if (!entityLiving.hasEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT)) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        if (!EnhancedPickaxe.canBeMinedInGroup(blockState)) {
            return;
        }
        float originHardness = blockState.getBlock().defaultDestroyTime();
        if (originHardness == 0.0f) {
            return;
        }
        Direction facing = this.utils.player.getDirection(entityLiving, pos);
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        int c = switch (facing) {
            case Direction.NORTH, Direction.SOUTH -> {
                a = 1;
                b = 1;
                yield 0;
            }
            case Direction.EAST, Direction.WEST -> {
                a = 0;
                b = 1;
                yield 1;
            }
            default -> {
                a = 1;
                b = 0;
                yield 1;
            }
        };
        for (int x = posX - a; x <= posX + a; ++x) {
            for (int y = posY - b; y <= posY + b; ++y) {
                for (int z = posZ - c; z <= posZ + c; ++z) {
                    if (x == posX && y == posY && z == posZ) continue;
                    this.onBlockMining(level, blockState, originHardness, new BlockPos(x, y, z), entityLiving);
                }
            }
        }
    }

    private static boolean canBeMinedInGroup(BlockState blockState) {
        return !blockState.hasBlockEntity() && (blockState == blockState.getBlock().defaultBlockState() || blockState.is(BlockTags.REDSTONE_ORES) || blockState.is(BlockRegistry.GREEN_DIAMOND_ORE));
    }

    protected void onBlockMining(Level level, BlockState originBlockState, float originHardness, BlockPos pos, LivingEntity entityLiving) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!EnhancedPickaxe.canBeMinedInGroup(blockState)) {
            return;
        }
        float hardness = block.defaultDestroyTime();
        if (hardness <= originHardness && this.isToolEffective(entityLiving, pos) && (this.materialProperties.isSafeToBreak(entityLiving, pos) || entityLiving.isShiftKeyDown())) {
            Block originBlock = originBlockState.getBlock();
            if ((!this.utils.blocks.types.isOre(originBlockState) || originBlock == block) && this.utils.player.destroyBlockByMainHandTool(level, pos, entityLiving, blockState, block)) {
                this.damageMainHandItem(1, entityLiving);
            }
        }
    }
}

