/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.utils.SoundType;
import com.pekar.angelblock.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface IToolService {
    default public void setBlock(Player player, BlockPos pos, Block block) {
        this.setBlock(player, pos, block.defaultBlockState());
    }

    default public void setBlock(Player player, BlockPos pos, BlockState blockState) {
        player.level().setBlock(pos, blockState, 11);
        Utils.instance.sound.playSoundByBlock(player, pos, SoundType.BLOCK_CHANGED);
    }

    default public InteractionResult getToolInteractionResult(boolean applied, boolean isClientSide) {
        if (!applied) {
            return InteractionResult.PASS;
        }
        return isClientSide ? InteractionResult.SUCCESS_NO_ITEM_USED : InteractionResult.CONSUME_PARTIAL;
    }

    default public void causePlayerExhaustion(Player player) {
        if (player != null && !player.level().isClientSide()) {
            FoodData foodData = player.getFoodData();
            foodData.setSaturation(foodData.getSaturationLevel() * 0.5f);
            player.causeFoodExhaustion(0.5f);
        }
    }
}

