/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.blocks.ModBlock;
import com.pekar.angelblock.blocks.tile_entities.AngelRodBlockEntity;
import com.pekar.angelblock.blocks.tile_entities.EntityRegistry;
import com.pekar.angelblock.tools.ToolRegistry;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngelRodBlock
extends ModBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_X = Shapes.create((double)0.328125, (double)0.0, (double)0.46875, (double)0.671875, (double)1.21875, (double)0.53125);
    private static final VoxelShape SHAPE_Z = Shapes.create((double)0.46875, (double)0.0, (double)0.328125, (double)0.53125, (double)1.21875, (double)0.671875);
    public static final BooleanProperty FACING_ALONG_X = BooleanProperty.create((String)"facing_along_x");

    public AngelRodBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING_ALONG_X});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        return switch (direction) {
            case Direction.EAST, Direction.WEST -> (BlockState)this.defaultBlockState().setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(false));
            default -> (BlockState)this.defaultBlockState().setValue((Property)FACING_ALONG_X, (Comparable)Boolean.valueOf(true));
        };
    }

    protected Function<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> voxelShapeFunction) {
        return blockState -> (Boolean)blockState.getValue((Property)FACING_ALONG_X) != false ? SHAPE_X : SHAPE_Z;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.getValue((Property)FACING_ALONG_X) != false ? SHAPE_X : SHAPE_Z;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return ((BlockEntityType)EntityRegistry.ANGEL_ROD_BLOCK_ENTITY.get()).create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> entityType) {
        return level.isClientSide() ? null : (level0, pos, blockState0, blockEntity) -> ((AngelRodBlockEntity)blockEntity).tick(level0, pos, blockState0, (AngelRodBlockEntity)blockEntity);
    }

    @NotNull
    public Item asItem() {
        return (Item)ToolRegistry.ANGEL_ROD.get();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && !player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof AngelRodBlockEntity) {
            AngelRodBlockEntity angelRodBlockEntity = (AngelRodBlockEntity)blockEntity;
            Direction dropDirection = player.getDirection().getOpposite();
            if (player.isSteppingCarefully()) {
                ItemStack itemStack1 = new ItemStack((ItemLike)ToolRegistry.END_MAGNETIC_ROD.get());
                itemStack1.setDamageValue(angelRodBlockEntity.getDamage());
                ItemStack itemStack2 = new ItemStack((ItemLike)BlockRegistry.ANGEL_BLOCK.get());
                ItemStack itemStack3 = new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING);
                AngelRodBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)dropDirection, (ItemStack)itemStack1);
                AngelRodBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)dropDirection, (ItemStack)itemStack2);
                AngelRodBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)dropDirection, (ItemStack)itemStack3);
            } else {
                ItemStack itemStack = new ItemStack((ItemLike)ToolRegistry.ANGEL_ROD.get());
                itemStack.setDamageValue(angelRodBlockEntity.getDamage());
                AngelRodBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)dropDirection, (ItemStack)itemStack);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }
}

