/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.armor.Armor;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.DolphinsGraceSwitchingEffect;
import com.pekar.angelblock.events.effect.GlowingSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.HasteSwitchingEffect;
import com.pekar.angelblock.events.effect.HealthBoostPermanentArmorEffect;
import com.pekar.angelblock.events.effect.IPermanentArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingEffectSynchronizer;
import com.pekar.angelblock.events.effect.ITemporaryArmorEffect;
import com.pekar.angelblock.events.effect.ITemporaryPersistentArmorEffect;
import com.pekar.angelblock.events.effect.JumpBoostSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.JumpNegativeArmorEffect;
import com.pekar.angelblock.events.effect.LevitationSwitchingEffect;
import com.pekar.angelblock.events.effect.LuckPermanentArmorEffect;
import com.pekar.angelblock.events.effect.NightVisionSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.RegenerationTemporaryArmorEffect;
import com.pekar.angelblock.events.effect.SlowFallingSwitchingEffect;
import com.pekar.angelblock.events.effect.SpeedSwitchingEffect;
import com.pekar.angelblock.events.effect.StrengthSwitchingEffect;
import com.pekar.angelblock.events.effect.SuperJumpSwitchingEffect;
import com.pekar.angelblock.events.effect.SwitchingEffectSynchronizer;
import com.pekar.angelblock.events.effect.WaterBreathingSwitchingEffect;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.keybinds.KeyRegistry;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class SuperArmor
extends Armor {
    private final ISwitchingArmorEffect nightVisionEffect;
    private final ISwitchingEffectSynchronizer jumpEffect;
    private final ISwitchingArmorEffect glowingEffect;
    private final IPermanentArmorEffect luckEffect;
    private final ITemporaryArmorEffect regenerationEffect;
    private final IPermanentArmorEffect healthBoostEffect;
    private final ITemporaryPersistentArmorEffect jumpNegativeEffect;
    private final ISwitchingArmorEffect levitationEffect;
    private final ISwitchingArmorEffect slowFallingEffect;
    private final ISwitchingEffectSynchronizer superJumpEffect;
    private boolean isSlowFallingActivatedOnGround = true;
    private static final int HEAL_REGENERATION_EFFECT_DURATION = 300;
    private static final int REGENERATION_EFFECT_UNDER_RAIN_AMPLIFIER = 0;
    private static final int REGENERATION_EFFECT_HEAL_AMPLIFIER = 1;
    private static final int SLOWNESS_EFFECT_DURATION = 600;
    private static final int MONSTER_SLOWDOWNED_EFFECT_DURATION = 100;
    private static final int ATTACKING_MONSTER_GLOWING_EFFECT_DURATION = 1200;
    private static final int LEVITATION_UP_AMPLIFIER = 3;
    private static final int SUPER_JUMP_AMPLIFIER = 30;

    public SuperArmor(IPlayer player) {
        super(player);
        this.nightVisionEffect = (ISwitchingArmorEffect)new NightVisionSwitchingArmorEffect(player, this).availableIfSlotSet(EquipmentSlot.HEAD);
        this.glowingEffect = (ISwitchingArmorEffect)new GlowingSwitchingArmorEffect(player, this).availableIfSlotsSet(EquipmentSlot.CHEST);
        this.luckEffect = (IPermanentArmorEffect)new LuckPermanentArmorEffect(player, this).availableIfSlotSet(EquipmentSlot.CHEST);
        this.regenerationEffect = new RegenerationTemporaryArmorEffect(player, (IArmor)this, 1, 300);
        this.jumpNegativeEffect = new JumpNegativeArmorEffect(player, (IArmor)this, 2, 600);
        this.healthBoostEffect = new HealthBoostPermanentArmorEffect(player, this, 2);
        this.levitationEffect = (ISwitchingArmorEffect)new LevitationSwitchingEffect(player, this, 3).availableIfSlotSet(EquipmentSlot.CHEST);
        this.slowFallingEffect = (ISwitchingArmorEffect)new SlowFallingSwitchingEffect(player, this).availableIfSlotSet(EquipmentSlot.CHEST);
        SuperJumpSwitchingEffect superJumpEffect = new SuperJumpSwitchingEffect(player, this);
        superJumpEffect.setupAvailability(this::isSuperJumpEffectAvailable);
        DolphinsGraceSwitchingEffect dolphinsGraceEffect = new DolphinsGraceSwitchingEffect(player, this);
        this.superJumpEffect = new SwitchingEffectSynchronizer(superJumpEffect);
        this.superJumpEffect.addDependentEffect(dolphinsGraceEffect);
        JumpBoostSwitchingArmorEffect jumpEffect = new JumpBoostSwitchingArmorEffect(player, this, 5);
        jumpEffect.availableIfSlotSet(EquipmentSlot.FEET);
        SpeedSwitchingEffect speedEffect = new SpeedSwitchingEffect(player, this, 1);
        StrengthSwitchingEffect strengthEffect = new StrengthSwitchingEffect(player, this, 2);
        WaterBreathingSwitchingEffect waterBreathingEffect = new WaterBreathingSwitchingEffect(player, this);
        waterBreathingEffect.availableIfSlotSet(EquipmentSlot.HEAD);
        HasteSwitchingEffect hasteEffect = new HasteSwitchingEffect(player, this, 1);
        hasteEffect.availableIfSlotSet(EquipmentSlot.CHEST);
        this.jumpEffect = new SwitchingEffectSynchronizer(jumpEffect);
        this.jumpEffect.addDependentEffect(speedEffect);
        this.jumpEffect.addDependentInvertedEffect(strengthEffect);
        this.jumpEffect.addDependentInvertedEffect(waterBreathingEffect);
        this.jumpEffect.addDependentInvertedEffect(hasteEffect);
    }

    @Override
    protected void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.isSlowFallingActivatedOnGround = this.player.getEntity().onGround();
    }

    @Override
    protected void updateAvailability() {
        this.jumpNegativeEffect.updateAvailability();
        this.slowFallingEffect.updateAvailability();
        this.glowingEffect.updateAvailability();
        this.levitationEffect.updateAvailability();
        this.luckEffect.updateAvailability();
        this.healthBoostEffect.updateAvailability();
        this.regenerationEffect.updateAvailability();
        this.nightVisionEffect.updateAvailability();
        this.jumpEffect.updateAvailability();
        this.superJumpEffect.updateAvailability();
    }

    @Override
    protected void updateEffectStates() {
        this.nightVisionEffect.updateSwitchState();
        this.glowingEffect.updateSwitchState();
        if (!this.jumpNegativeEffect.isAnyActive()) {
            this.jumpEffect.updateSwitchState();
            this.levitationEffect.updateSwitchState();
            this.slowFallingEffect.updateSwitchState();
            this.superJumpEffect.updateSwitchState();
        }
    }

    @Override
    protected void updateActivityForHeadSlot() {
        this.nightVisionEffect.updateActivity();
    }

    @Override
    protected void updateActivityForFeetSlot() {
    }

    @Override
    protected void updateActivityForLegsSlot() {
        this.healthBoostEffect.updateActivity();
        this.regenerationEffect.updateActivity();
    }

    @Override
    protected void updateActivityForChestSlot() {
        this.slowFallingEffect.updateActivity();
        this.glowingEffect.updateActivity();
        this.levitationEffect.updateActivity(3);
        this.luckEffect.updateActivity();
    }

    @Override
    protected void updateActivity(EquipmentSlot slot) {
        this.superJumpEffect.updateActivity();
        if (!this.jumpNegativeEffect.isActive()) {
            this.jumpEffect.updateActivity();
        } else {
            this.jumpEffect.updateDependentEffectsActivity();
        }
    }

    @Override
    protected void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        Player entityPlayer = this.player.getEntity();
        if (this.playerNeedsToRestoreHealth(entityPlayer, event.getSlot(), event.getFrom(), event.getTo())) {
            this.restorePlayerHealth(entityPlayer);
        }
    }

    @Override
    public void onLivingHurtEvent(LivingIncomingDamageEvent event) {
        DamageSource damageSource = event.getSource();
        boolean isFullArmorSet = this.player.isFullArmorSetPutOn(this);
        if (this.isFireDamage(damageSource)) {
            if (!this.isStandingInSoulFire()) {
                float realDamage = this.getRealDamage(event.getAmount());
                event.setCanceled(realDamage <= 0.0f);
            }
            if (isFullArmorSet) {
                event.getEntity().clearFire();
            }
        } else if (this.isHotFloorDamage(damageSource) || this.isFreezeDamage(damageSource)) {
            boolean areBootsWorn = this.player.isArmorElementPutOn(this, EquipmentSlot.FEET);
            event.setCanceled(areBootsWorn);
        } else if (this.hasImmunity(damageSource)) {
            event.setCanceled(this.player.areLeggingsModifiedWithHealthRegenerator(this));
        } else if (damageSource.is(DamageTypes.WITHER)) {
            if (this.player.areLeggingsModifiedWithHealthRegenerator(this)) {
                event.setCanceled(true);
                this.player.getEntity().removeEffect(MobEffects.WITHER);
            }
        } else if (this.isLightningBoltDamage(damageSource)) {
            if (isFullArmorSet) {
                event.setCanceled(true);
            }
        } else if (this.player.isEffectActive((Holder<MobEffect>)MobEffects.POISON) && this.player.areLeggingsModifiedWithHealthRegenerator(this)) {
            this.player.clearEffect((Holder<MobEffect>)MobEffects.POISON);
            event.setCanceled(damageSource.getMsgId().equals("magic"));
        }
        if (isFullArmorSet) {
            Entity entity = damageSource.getEntity();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity entityAttackedBy = (LivingEntity)entity;
            if (this.isSlowMovementAffected(entityAttackedBy)) {
                boolean isWitch = entityAttackedBy instanceof Witch;
                float distance = this.player.getEntity().distanceTo((Entity)entityAttackedBy);
                if (!isWitch && distance > 2.0f) {
                    entityAttackedBy.setRemainingFireTicks(100);
                } else {
                    entityAttackedBy.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 100, 2));
                }
            }
            MobEffectInstance effect = new MobEffectInstance(MobEffects.GLOWING, 1200, 0, false, false, false);
            entityAttackedBy.addEffect(effect);
        }
    }

    @Override
    public void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        DamageSource damageSource = event.getSource();
        boolean isFullArmorSet = this.player.isFullArmorSetPutOn(this);
        if (this.isFireDamage(damageSource) && !this.isStandingInSoulFire()) {
            float realDamage = this.getRealDamage(event.getNewDamage());
            event.setNewDamage(realDamage);
        } else if (this.isLavaDamage(damageSource)) {
            if (isFullArmorSet) {
                event.setNewDamage(0.05f * event.getNewDamage());
            }
        } else if (this.isExplosionDamage(damageSource)) {
            if (this.player.isChestPlateModifiedWithStrengthBooster(this)) {
                event.setNewDamage(event.getNewDamage() * 0.5f);
            }
        } else if (this.isBiting(damageSource.getEntity()) && isFullArmorSet) {
            float damageAmount = event.getNewDamage();
            event.setNewDamage(damageAmount * 0.2f);
        }
    }

    @Override
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        this.updateSlowFallingEffect();
        if (!this.player.isArmorElementPutOn(this, EquipmentSlot.FEET)) {
            return;
        }
        if (this.jumpEffect.isMasterActive() || this.jumpNegativeEffect.isAnyActive()) {
            return;
        }
        if (this.slowFallingEffect.isOn() && this.slowFallingEffect.isActive()) {
            this.player.setEffect((Holder<MobEffect>)MobEffects.JUMP_BOOST, 30, 6);
        } else if (this.superJumpEffect.isMasterActive()) {
            this.player.setEffect((Holder<MobEffect>)MobEffects.JUMP_BOOST, 20, 30);
        }
    }

    @Override
    public void onLivingFallEvent(LivingFallEvent event) {
    }

    @Override
    public void onCreeperCheck() {
        this.updateSlowFallingEffect();
        Player playerEntity = this.player.getEntity();
        if (playerEntity.isFallFlying() && !this.canFly()) {
            playerEntity.stopFallFlying();
        }
        boolean isHelmetModifiedWithDetector = this.player.isHelmetModifiedWithDetector(this);
        this.detectCreepers(isHelmetModifiedWithDetector, false);
    }

    @Override
    public void onEffectAddedEvent(MobEffectEvent.Added event) {
    }

    @Override
    public void onKeyInputEvent(String pressedKeyDescription) {
        Player playerEntity = this.player.getEntity();
        if (pressedKeyDescription.equals(KeyRegistry.NIGHT_VISION.getName())) {
            this.nightVisionEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.GLOWING.getName())) {
            this.glowingEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.REGENERATION.getName()) && this.regenerationEffect.isAvailable() && !this.regenerationEffect.isAnyActive() && playerEntity.getHealth() < playerEntity.getMaxHealth()) {
            this.jumpEffect.trySwitchOff();
            this.levitationEffect.trySwitchOff();
            this.slowFallingEffect.trySwitchOff();
            this.jumpNegativeEffect.tryActivate();
            this.regenerationEffect.tryActivate();
            if (this.regenerationEffect.isActive() && !playerEntity.onGround() && this.slowFallingEffect.isAvailable()) {
                this.slowFallingEffect.trySwitchOn();
                this.isSlowFallingActivatedOnGround = false;
            }
        }
        if (pressedKeyDescription.equals(KeyRegistry.JUMP_BOOST.getName())) {
            if (!this.jumpNegativeEffect.isAnyActive()) {
                this.jumpEffect.trySwitch();
            }
            if (this.jumpEffect.isMasterActive() && this.slowFallingEffect.isActive() && this.player.getEntity().onGround() && !this.levitationEffect.isAnyActive()) {
                this.slowFallingEffect.trySwitchOff();
                this.levitationEffect.trySwitchOn();
            } else if (!this.jumpEffect.isMasterActive() && this.levitationEffect.isActive()) {
                this.levitationEffect.trySwitchOff();
                if (this.slowFallingEffect.isAvailable()) {
                    this.slowFallingEffect.trySwitchOn();
                    this.isSlowFallingActivatedOnGround = playerEntity.onGround();
                }
            }
        }
        if (pressedKeyDescription.equals(KeyRegistry.LEVITATION.getName())) {
            if (!this.levitationEffect.isOn() && this.levitationEffect.isAnyActive() && this.levitationEffect.isInfinite()) {
                this.levitationEffect.forceRemove();
            }
            if (!this.jumpNegativeEffect.isAnyActive()) {
                if (this.jumpEffect.isMasterAvailable() && this.jumpEffect.isOn()) {
                    if (this.levitationEffect.isAvailable() && this.levitationEffect.isActive()) {
                        this.jumpEffect.trySwitchOff();
                        this.levitationEffect.trySwitchOff();
                        if (this.slowFallingEffect.isAvailable()) {
                            this.slowFallingEffect.trySwitchOn();
                            this.isSlowFallingActivatedOnGround = playerEntity.onGround();
                        }
                    } else if (!playerEntity.onGround()) {
                        if (this.slowFallingEffect.isAvailable()) {
                            this.slowFallingEffect.trySwitchOn();
                            this.isSlowFallingActivatedOnGround = false;
                        }
                    } else if (!playerEntity.isInLava() && !this.levitationEffect.isAnyActive()) {
                        this.levitationEffect.trySwitch(3);
                    }
                } else {
                    this.slowFallingEffect.trySwitch();
                    this.isSlowFallingActivatedOnGround = this.slowFallingEffect.isOn() ? playerEntity.onGround() : true;
                }
            }
            if (this.slowFallingEffect.isActive()) {
                playerEntity.stopFallFlying();
            }
        }
        if (pressedKeyDescription.equals(KeyRegistry.SUPER_JUMP.getName())) {
            this.superJumpEffect.trySwitch();
        }
        if (this.levitationEffect.isOn()) {
            this.slowFallingEffect.trySwitchOff();
        }
    }

    @Override
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
    }

    @Override
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
    }

    @Override
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (this.jumpEffect.isOn()) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.2f);
        }
    }

    @Override
    public void onBeingInLava() {
        if (this.slowFallingEffect.isOn()) {
            this.slowFallingEffect.trySwitchOff();
            this.isSlowFallingActivatedOnGround = true;
        }
    }

    @Override
    public void onBeingInWater() {
        if (this.slowFallingEffect.isOn()) {
            this.slowFallingEffect.trySwitchOff();
            this.isSlowFallingActivatedOnGround = true;
        }
    }

    @Override
    public void onBeingUnderRain() {
        if (!this.player.isFullArmorSetPutOn(this)) {
            return;
        }
        Player entityPlayer = this.player.getEntity();
        if (entityPlayer.getHealth() < entityPlayer.getMaxHealth()) {
            this.regenerationEffect.tryActivate(0, 100);
            entityPlayer.causeFoodExhaustion(0.5f);
        }
    }

    @Override
    public String getFamilyName() {
        return ((ModArmor)ArmorRegistry.SUPER_BOOTS.get()).getArmorFamilyName();
    }

    @Override
    public int getPriority() {
        return 6;
    }

    private float getRealDamage(float initialDamageAmount) {
        float helmetProtection = this.player.isArmorElementPutOn(this, EquipmentSlot.HEAD) ? initialDamageAmount * 0.2f : 0.0f;
        float bootsProtection = this.player.isArmorElementPutOn(this, EquipmentSlot.FEET) ? initialDamageAmount * 0.2f : 0.0f;
        float chestplateProtection = this.player.isArmorElementPutOn(this, EquipmentSlot.CHEST) ? initialDamageAmount * 0.35f : 0.0f;
        float leggingsProtection = this.player.isArmorElementPutOn(this, EquipmentSlot.LEGS) ? initialDamageAmount * 0.3f : 0.0f;
        float realDamage = initialDamageAmount - helmetProtection - bootsProtection - chestplateProtection - leggingsProtection;
        return realDamage > 0.0f ? realDamage : 0.0f;
    }

    private boolean hasImmunity(DamageSource damageSource) {
        return this.isThornOrMagicDamage(damageSource) || damageSource.is(DamageTypes.DRAGON_BREATH);
    }

    private boolean isSuperJumpEffectAvailable(IPlayer player, IArmor armor) {
        int maxBootsDamageToJump;
        if (!player.areBootsModifiedWithJumpBooster(this)) {
            return false;
        }
        ItemStack boots = player.getEntity().getItemBySlot(EquipmentSlot.FEET);
        int bootsDamage = boots.getDamageValue();
        return bootsDamage < (maxBootsDamageToJump = boots.getMaxDamage() / 2);
    }

    private boolean canFly() {
        Player playerEntity = this.player.getEntity();
        ItemStack chestplate = playerEntity.getItemBySlot(EquipmentSlot.CHEST);
        int maxDamageToFly = chestplate.getMaxDamage() / 2;
        int chestDamage = chestplate.getDamageValue();
        return chestDamage < maxDamageToFly;
    }

    private void updateSlowFallingEffect() {
        if (!this.isSlowFallingActivatedOnGround && this.slowFallingEffect.isOn() && this.player.getEntity().onGround()) {
            this.slowFallingEffect.trySwitchOff();
            this.isSlowFallingActivatedOnGround = true;
        }
    }
}

