/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.cleaners;

import com.pekar.angelblock.events.cleaners.ITargetBehavior;
import com.pekar.angelblock.events.cleaners.ITrackedTarget;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;

public abstract class Cleaner {
    private static final Set<ITrackedTarget> targets = ConcurrentHashMap.newKeySet();

    public static void add(ITrackedTarget trackedTarget) {
        targets.add(trackedTarget);
    }

    public static void decrementOrRemove() {
        if (targets.isEmpty()) {
            return;
        }
        Iterator<ITrackedTarget> iterator = targets.iterator();
        while (iterator.hasNext()) {
            ITrackedTarget target = iterator.next();
            ITargetBehavior targetBehavior = target.getBehavior();
            if (targetBehavior.shouldDecrement()) {
                target.decrementTick();
            }
            if (targetBehavior.shouldReset()) {
                target.resetTick();
            }
            if (targetBehavior.shouldRemove()) {
                target.remove();
                iterator.remove();
            }
            if (!targetBehavior.shouldUntrack()) continue;
            iterator.remove();
        }
    }

    public static void clean(Player player) {
        if (targets.isEmpty()) {
            return;
        }
        Iterator<ITrackedTarget> iterator = targets.iterator();
        while (iterator.hasNext()) {
            ITrackedTarget target = iterator.next();
            if (!target.getOwner().getUUID().equals(player.getUUID())) continue;
            ITargetBehavior behavior = target.getBehavior();
            if (behavior.canBeRemovedOnClean()) {
                target.remove();
                behavior.onRemove();
            } else {
                behavior.onUnableToRemove();
            }
            iterator.remove();
        }
    }
}

