/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.menus;

import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.items.ItemRegistry;
import com.pekar.angelblock.tools.AmethystRod;
import com.pekar.angelblock.tools.AncientRod;
import com.pekar.angelblock.tools.AngelRod;
import com.pekar.angelblock.tools.Builder;
import com.pekar.angelblock.tools.EndRod;
import com.pekar.angelblock.tools.FireRod;
import com.pekar.angelblock.tools.IModTool;
import com.pekar.angelblock.tools.MarineRod;
import com.pekar.angelblock.tools.ModRod;
import com.pekar.angelblock.tools.Planter;
import com.pekar.angelblock.tools.TrackLayer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class CustomSmithingMenu
extends SmithingMenu {
    public CustomSmithingMenu(int containerId, Inventory playerInventory) {
        super(containerId, playerInventory);
    }

    public CustomSmithingMenu(int containerId, Inventory playerInventory, ContainerLevelAccess access) {
        super(containerId, playerInventory, access);
    }

    protected void onTake(Player player, ItemStack stack) {
        ItemStack template = this.getSlot(0).getItem();
        ItemStack mainItem = this.getSlot(1).getItem();
        ItemStack secondaryItem = this.getSlot(2).getItem();
        ItemStack result = stack;
        if (template.is(ItemRegistry.DOWNGRADE_KIT) && secondaryItem.is(Items.FLINT)) {
            Item item = mainItem.getItem();
            if (item instanceof ModArmor) {
                ModArmor resultAsModArmor;
                ModArmor armor = (ModArmor)item;
                materialName = armor.getArmorMaterial().getMaterialName();
                boolean isResultModArmor = result.getItem() instanceof ModArmor;
                ModArmor modArmor = resultAsModArmor = isResultModArmor ? (ModArmor)result.getItem() : null;
                if (!isResultModArmor || !armor.getArmorFamilyName().equals(resultAsModArmor.getArmorFamilyName())) {
                    player.getInventory().add(new ItemStack((ItemLike)(switch (materialName) {
                        case "rendelithic" -> (Item)ItemRegistry.RENDELITHIC_PLATE.get();
                        case "limonite" -> (Item)ItemRegistry.LIMONITE_PLATE.get();
                        case "diamithic" -> (Item)ItemRegistry.DIAMITHIC_PLATE.get();
                        case "lapis" -> (Item)ItemRegistry.LAPIS_PLATE.get();
                        case "super" -> (Item)ItemRegistry.SUPER_PLATE.get();
                        case "flying" -> (Item)ItemRegistry.FLYING_PLATE.get();
                        default -> Items.AIR;
                    })));
                }
                if (!(!armor.isModifiedWithDetector() || isResultModArmor && resultAsModArmor.isModifiedWithDetector())) {
                    player.getInventory().add(new ItemStack((ItemLike)Blocks.CALIBRATED_SCULK_SENSOR));
                }
                if (!(!armor.isModifiedWithNightVision() || isResultModArmor && resultAsModArmor.isModifiedWithNightVision())) {
                    player.getInventory().add(new ItemStack((ItemLike)ItemRegistry.GUARDIAN_EYE.get()));
                }
                if (!(!armor.isModifiedWithStrengthBooster() || isResultModArmor && resultAsModArmor.isModifiedWithStrengthBooster())) {
                    player.getInventory().add(new ItemStack((ItemLike)ItemRegistry.STRENGTH_PEARL.get()));
                }
                if (!(!armor.isModifiedWithJumpBooster() || isResultModArmor && resultAsModArmor.isModifiedWithJumpBooster())) {
                    player.getInventory().add(new ItemStack((ItemLike)ItemRegistry.STRENGTH_PEARL.get()));
                }
                if (!(!armor.isModifiedWithHealthRegenerator() || isResultModArmor && resultAsModArmor.isModifiedWithHealthRegenerator())) {
                    player.getInventory().add(new ItemStack((ItemLike)ItemRegistry.BIOS_DIAMOND.get()));
                }
                if (!(!armor.isModifiedWithSlowFalling() || isResultModArmor && resultAsModArmor.isModifiedWithSlowFalling())) {
                    player.getInventory().add(new ItemStack((ItemLike)ItemRegistry.SOARING_SPORE_ESSENCE.get()));
                }
                if (!(!armor.isModifiedWithSeaPower() || isResultModArmor && resultAsModArmor.isModifiedWithSeaPower())) {
                    player.getInventory().add(new ItemStack((ItemLike)Items.HEART_OF_THE_SEA));
                }
                if (!(!armor.isModifiedWithLuck() || isResultModArmor && resultAsModArmor.isModifiedWithLuck())) {
                    player.getInventory().add(new ItemStack((ItemLike)Items.HEART_OF_THE_SEA));
                }
                if (!(!armor.isModifiedWithElytra() || isResultModArmor && resultAsModArmor.isModifiedWithElytra())) {
                    player.getInventory().add(new ItemStack((ItemLike)Items.ELYTRA));
                }
            } else {
                materialName = mainItem.getItem();
                if (materialName instanceof IModTool) {
                    IModTool resultAsModTool;
                    IModTool tool = (IModTool)materialName;
                    materialName = tool.getMaterialName();
                    boolean isResultModTool = result.getItem() instanceof IModTool;
                    IModTool iModTool = resultAsModTool = isResultModTool ? (IModTool)result.getItem() : null;
                    if (tool instanceof ModRod) {
                        ItemStack dropItem1;
                        ModRod rod = (ModRod)tool;
                        boolean isResultModRod = result.getItem() instanceof ModRod;
                        ModRod resultAsModRod = isResultModRod ? (ModRod)result.getItem() : null;
                        ItemStack dropItem2 = new ItemStack((ItemLike)Items.AIR);
                        ModRod modRod = rod;
                        Objects.requireNonNull(modRod);
                        ModRod modRod2 = modRod;
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AngelRod.class, EndRod.class, AmethystRod.class, FireRod.class, MarineRod.class, AncientRod.class, TrackLayer.class, Planter.class, Builder.class}, (Object)modRod2, n)) {
                            case 0: {
                                AngelRod angelRod = (AngelRod)modRod2;
                                dropItem1 = new ItemStack((ItemLike)Items.AIR);
                                break;
                            }
                            case 1: {
                                EndRod endRod = (EndRod)modRod2;
                                dropItem1 = new ItemStack((ItemLike)ItemRegistry.SUPER_CRYSTAL.get());
                                break;
                            }
                            case 2: {
                                AmethystRod amethystRod = (AmethystRod)modRod2;
                                dropItem1 = new ItemStack((ItemLike)Items.AMETHYST_SHARD);
                                break;
                            }
                            case 3: {
                                FireRod fireRod = (FireRod)modRod2;
                                dropItem1 = new ItemStack((ItemLike)ItemRegistry.FLAME_STONE.get());
                                break;
                            }
                            case 4: {
                                MarineRod marineRod = (MarineRod)modRod2;
                                dropItem1 = new ItemStack((ItemLike)ItemRegistry.MARINE_CRYSTAL.get());
                                break;
                            }
                            case 5: {
                                AncientRod ancientRod = (AncientRod)modRod2;
                                dropItem1 = new ItemStack((ItemLike)ItemRegistry.BIOS_DIAMOND.get());
                                break;
                            }
                            case 6: {
                                TrackLayer trackLayer = (TrackLayer)modRod2;
                                dropItem1 = new ItemStack((ItemLike)Blocks.PISTON);
                                dropItem2 = new ItemStack((ItemLike)Items.FISHING_ROD);
                                break;
                            }
                            case 7: {
                                Planter planter = (Planter)modRod2;
                                dropItem1 = new ItemStack((ItemLike)Blocks.DISPENSER);
                                dropItem2 = new ItemStack((ItemLike)Items.NAUTILUS_SHELL);
                                break;
                            }
                            case 8: {
                                Builder builder = (Builder)modRod2;
                                dropItem1 = new ItemStack((ItemLike)Blocks.PISTON);
                                dropItem2 = new ItemStack((ItemLike)ItemRegistry.STRENGTH_PEARL.get());
                                break;
                            }
                            default: {
                                dropItem1 = new ItemStack((ItemLike)Items.AIR);
                            }
                        }
                        if (!dropItem1.isEmpty()) {
                            player.getInventory().add(dropItem1);
                        }
                        if (!dropItem2.isEmpty()) {
                            player.getInventory().add(dropItem2);
                        }
                        if (!(!rod.isEnhanced() || isResultModRod && resultAsModRod.isEnhanced())) {
                            player.getInventory().add(new ItemStack((ItemLike)ItemRegistry.ROD_SENSOR.get()));
                        }
                    } else {
                        ItemStack dropItem1;
                        ItemStack dropItem2 = switch (materialName) {
                            case "diamithic" -> {
                                dropItem1 = ItemRegistry.DIAMITHIC_INGOT.toStack();
                                yield ItemRegistry.STRENGTH_PEARL.toStack();
                            }
                            case "lapis" -> {
                                dropItem1 = ItemRegistry.LAPIS_INGOT.toStack();
                                yield ItemRegistry.MARINE_CRYSTAL.toStack();
                            }
                            case "limonite" -> {
                                dropItem1 = ItemRegistry.LIMONITE_INGOT.toStack();
                                yield ItemRegistry.BIOS_DIAMOND.toStack();
                            }
                            case "super" -> {
                                dropItem1 = ItemRegistry.SUPER_INGOT.toStack();
                                yield ItemRegistry.SUPER_CRYSTAL.toStack();
                            }
                            case "rendelithic" -> {
                                dropItem1 = ItemRegistry.RENDELITHIC_INGOT.toStack();
                                yield ItemRegistry.FLAME_STONE.toStack();
                            }
                            default -> {
                                dropItem1 = Items.AIR.getDefaultInstance();
                                yield Items.AIR.getDefaultInstance();
                            }
                        };
                        if (!isResultModTool || !tool.getMaterialName().equals(resultAsModTool.getMaterialName())) {
                            player.getInventory().add(dropItem1);
                        }
                        if (!(!tool.isEnhanced() || isResultModTool && resultAsModTool.isEnhanced())) {
                            player.getInventory().add(dropItem2);
                        }
                    }
                } else if (mainItem.is(ItemTags.TRIMMABLE_ARMOR) && result.is(ItemTags.TRIMMABLE_ARMOR)) {
                    if (mainItem.is(ItemRegistry.NETHERITE_ARMOR_TAG) && result.is(ItemRegistry.DIAMOND_ARMOR_TAG)) {
                        player.getInventory().add(Items.NETHERITE_INGOT.getDefaultInstance());
                    }
                } else if (mainItem.getItem().getDefaultInstance().is(ItemRegistry.NETHERITE_TOOL_TAG) && result.getItem().getDefaultInstance().is(ItemRegistry.DIAMOND_TOOL_TAG)) {
                    player.getInventory().add(Items.NETHERITE_INGOT.getDefaultInstance());
                }
            }
        }
        super.onTake(player, stack);
    }
}

