/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tab;

import com.pekar.angelblock.Main;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class ModTab {
    protected abstract String getTabName();

    protected abstract ItemStack getIconItem();

    protected abstract Collection<Item> getTabItems();

    protected abstract ResourceKey<CreativeModeTab>[] getTabsBefore();

    protected String getTitle() {
        return "itemGroup." + this.getTabName();
    }

    public final DeferredHolder<CreativeModeTab, CreativeModeTab> createTab() {
        return Main.CREATIVE_MODE_TABS.register(this.getTabName(), () -> CreativeModeTab.builder().title((Component)Component.translatable((String)this.getTitle())).withTabsBefore(this.getTabsBefore()).icon(() -> this.getIconItem()).displayItems(this::addItems).build());
    }

    private void addItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        for (Item item : this.getTabItems()) {
            output.accept((ItemLike)item);
        }
    }
}

