/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.armor;

import com.pekar.angelblock.items.ItemRegistry;
import com.pekar.angelblock.utils.Utils;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModArmorMaterial {
    private final Holder<ArmorMaterial> material;
    private final String materialName;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> armorResistanceMap;
    private final int enchantmentValue;
    private final float toughness;
    private final float knockbackResistance;
    private final Holder<SoundEvent> equipmentSound;
    private final Supplier<Ingredient> repairIngredient;
    private final boolean isFireResistant;
    public static final String RENDELITHIC_MATERIAL_NAME = "rendelithic";
    public static final String LIMONITE_MATERIAL_NAME = "limonite";
    public static final String DIAMITHIC_MATERIAL_NAME = "diamithic";
    public static final String LAPIS_MATERIAL_NAME = "lapis";
    public static final String SUPER_MATERIAL_NAME = "super";
    public static final String FLYING_MATERIAL_NAME = "flying";
    protected static final ModArmorMaterial RENDELITHIC = new ModArmorMaterial("rendelithic", "rendelithic_armor", ModArmorMaterial.createArmorTypeMap(3, 7, 9, 3, 7), 25, 0.0f, 0.0f, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RENDELITHIC_INGOT.get()}), true);
    protected static final ModArmorMaterial LIMONITE = new ModArmorMaterial("limonite", "limonite_armor", ModArmorMaterial.createArmorTypeMap(2, 5, 7, 3, 3), 30, 1.0f, 0.0f, 23, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIMONITE_INGOT.get()}), false);
    protected static final ModArmorMaterial LAPIS = new ModArmorMaterial("lapis", "lapis_armor", ModArmorMaterial.createArmorTypeMap(3, 6, 8, 3, 11), 10, 0.0f, 0.0f, 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LAPIS_INGOT.get()}), false);
    protected static final ModArmorMaterial DIAMITHIC = new ModArmorMaterial("diamithic", "diamithic_armor", ModArmorMaterial.createArmorTypeMap(3, 7, 9, 3, 11), 14, 3.0f, 0.2f, 45, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.DIAMITHIC_INGOT.get()}), false);
    protected static final ModArmorMaterial SUPER = new ModArmorMaterial("super", "super_armor", ModArmorMaterial.createArmorTypeMap(5, 9, 11, 5, 15), 1, 4.0f, 0.2f, 43, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SUPER_INGOT.get()}), true);
    protected static final ModArmorMaterial FLYING = new ModArmorMaterial("flying", "flying_armor", ModArmorMaterial.createArmorTypeMap(1, 2, 3, 1, 1), 0, 0.0f, 0.0f, 3, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_ELYTRA, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FLYING_INGOT.get()}), false);
    protected static final ModArmorMaterial RENDELITHIC2 = ModArmorMaterial.copyOf(RENDELITHIC, "rendelithic_armor2");
    protected static final ModArmorMaterial LIMONITE2 = ModArmorMaterial.copyOf(LIMONITE, "limonite_armor2");
    protected static final ModArmorMaterial DIAMITHIC2 = ModArmorMaterial.copyOf(DIAMITHIC, "diamithic_armor2");
    protected static final ModArmorMaterial LAPIS2 = ModArmorMaterial.copyOf(LAPIS, "lapis_armor2");
    protected static final ModArmorMaterial SUPER2 = ModArmorMaterial.copyOf(SUPER, "super_armor2");

    public ModArmorMaterial(String materialName, String armorModelName, EnumMap<ArmorItem.Type, Integer> armorResistanceMap, int enchantmentValue, float toughness, float knockbackResistance, int durabilityMultiplier, Holder<SoundEvent> equipmentSound, Supplier<Ingredient> repairIngredient, boolean isFireResistant) {
        this.material = ModArmorMaterial.register(armorModelName, armorResistanceMap, enchantmentValue, equipmentSound, toughness, knockbackResistance, repairIngredient);
        this.materialName = materialName;
        this.armorResistanceMap = armorResistanceMap;
        this.enchantmentValue = enchantmentValue;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.durabilityMultiplier = durabilityMultiplier;
        this.equipmentSound = equipmentSound;
        this.repairIngredient = repairIngredient;
        this.isFireResistant = isFireResistant;
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.material;
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    public boolean isFireResistant() {
        return this.isFireResistant;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModArmorMaterial)) {
            return false;
        }
        ModArmorMaterial another = (ModArmorMaterial)obj;
        return this.materialName.equals(another.materialName);
    }

    public int hashCode() {
        return this.materialName.hashCode();
    }

    private static Holder<ArmorMaterial> register(String armorName, EnumMap<ArmorItem.Type, Integer> map, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        List<ArmorMaterial.Layer> armorLayers = ModArmorMaterial.getNonDyeableArmorLayers(armorName);
        EnumMap<ArmorItem.Type, Integer> enummap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type armoritem$type : ArmorItem.Type.values()) {
            enummap.put(armoritem$type, map.get(armoritem$type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)Utils.instance.resources.createResourceLocation("angelblock", armorName), (Object)new ArmorMaterial(enummap, enchantmentValue, equipSound, repairIngredient, armorLayers, toughness, knockbackResistance));
    }

    private static EnumMap<ArmorItem.Type, Integer> createArmorTypeMap(int bootsResistance, int leggingsResistance, int chestplateResistance, int helmetResistance, int bodyResistance) {
        return (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), armorTypeMap -> {
            armorTypeMap.put(ArmorItem.Type.BOOTS, bootsResistance);
            armorTypeMap.put(ArmorItem.Type.LEGGINGS, leggingsResistance);
            armorTypeMap.put(ArmorItem.Type.CHESTPLATE, chestplateResistance);
            armorTypeMap.put(ArmorItem.Type.HELMET, helmetResistance);
            armorTypeMap.put(ArmorItem.Type.BODY, bodyResistance);
        });
    }

    private static List<ArmorMaterial.Layer> getNonDyeableArmorLayers(String armorName) {
        ResourceLocation resourceLocation = Utils.instance.resources.createResourceLocation("angelblock", armorName);
        return List.of(new ArmorMaterial.Layer(resourceLocation));
    }

    private static ModArmorMaterial copyOf(ModArmorMaterial armorMaterial, String armorModelName) {
        return new ModArmorMaterial(armorMaterial.materialName, armorModelName, armorMaterial.armorResistanceMap, armorMaterial.enchantmentValue, armorMaterial.toughness, armorMaterial.knockbackResistance, armorMaterial.durabilityMultiplier, armorMaterial.equipmentSound, armorMaterial.repairIngredient, armorMaterial.isFireResistant);
    }
}

