/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.blocks.ModBlock;
import com.pekar.angelblock.blocks.tile_entities.AngelBlockEntity;
import com.pekar.angelblock.blocks.tile_entities.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngelBlock
extends ModBlock
implements EntityBlock {
    public static final int MaxMonstersFilterValue = 4;
    public static final IntegerProperty MONSTERS_IN_FILTER = IntegerProperty.create((String)"monsters_in_filter", (int)0, (int)4);

    public AngelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MONSTERS_IN_FILTER, (Comparable)Integer.valueOf(0)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AngelBlockEntity) {
            AngelBlockEntity angelBlockEntity = (AngelBlockEntity)blockEntity;
            if (stack.isEmpty()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            boolean isClientSide = level.isClientSide();
            Item interactionItem = stack.getItem();
            if (interactionItem == Items.ECHO_SHARD) {
                boolean isReset = angelBlockEntity.resetFilter(player);
                if (!isReset) {
                    return ItemInteractionResult.FAIL;
                }
                if (!isClientSide) {
                    this.setBlockStateValue(level, pos, 0);
                }
                return ItemInteractionResult.sidedSuccess((boolean)isClientSide);
            }
            boolean isAdded = angelBlockEntity.addMonsterToFilter(interactionItem, player);
            if (isAdded) {
                this.setBlockStateValue(level, pos, angelBlockEntity.monstersInFilter());
            }
            return isAdded ? ItemInteractionResult.sidedSuccess((boolean)isClientSide) : ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return ((BlockEntityType)EntityRegistry.ANGEL_BLOCK_ENTITY.get()).create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> entityType) {
        return level.isClientSide() ? null : (level0, pos, blockState0, blockEntity) -> ((AngelBlockEntity)blockEntity).tick(level0, pos, blockState0, (AngelBlockEntity)blockEntity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MONSTERS_IN_FILTER});
    }

    public void setBlockStateValue(Level level, BlockPos pos, int value) {
        if (value > 4) {
            level.setBlock(pos, ((Block)BlockRegistry.INACTIVE_ANGEL_BLOCK.get()).defaultBlockState(), 11);
            return;
        }
        BlockState state = level.getBlockState(pos);
        level.setBlock(pos, (BlockState)state.setValue((Property)MONSTERS_IN_FILTER, (Comparable)Integer.valueOf(value)), 11);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!level.isClientSide) {
            level.playSound(null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

