/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks.tile_entities;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.blocks.tile_entities.EntityRegistry;
import com.pekar.angelblock.blocks.tile_entities.monsters.IMonster;
import com.pekar.angelblock.blocks.tile_entities.monsters.Monsters;
import com.pekar.angelblock.events.ILivingDeathEventHandler;
import com.pekar.angelblock.events.PlayerInteractionEvents;
import com.pekar.angelblock.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class DevilBlockEntity
extends BlockEntity
implements ILivingDeathEventHandler,
BlockEntityTicker<DevilBlockEntity> {
    private static final int EFFECTIVE_RADIUS = 70;
    private static final int SQR_EFFECTIVE_RADIUS = 4900;
    private static final int MONSTER_SPAWN_RADIUS = 30;
    private static final Random random = new Random();
    private final Map<Item, IMonster> monstersByActionItem = new HashMap<Item, IMonster>();

    public DevilBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityRegistry.DEVIL_BLOCK_ENTITY.get(), blockPos, blockState);
        this.activate();
        this.addToMonsterMap(Monsters.Skeleton);
        this.addToMonsterMap(Monsters.Zombie);
        this.addToMonsterMap(Monsters.Creeper);
        this.addToMonsterMap(Monsters.Enderman);
        this.addToMonsterMap(Monsters.Witch);
        this.addToMonsterMap(Monsters.Spider);
        this.addToMonsterMap(Monsters.Slime);
        this.addToMonsterMap(Monsters.MagmaCube);
        this.addToMonsterMap(Monsters.Guardian);
        this.addToMonsterMap(Monsters.Blaze);
        this.addToMonsterMap(Monsters.Ghast);
        this.addToMonsterMap(Monsters.Hoglin);
        this.addToMonsterMap(Monsters.PiglinBrute);
        this.addToMonsterMap(Monsters.WitherSkeleton);
        this.addToMonsterMap(Monsters.ZombieVillager);
        this.addToMonsterMap(Monsters.CaveSpider);
        this.addToMonsterMap(Monsters.Phantom);
        this.addToMonsterMap(Monsters.Shulker);
        this.addToMonsterMap(Monsters.Vindicator);
        this.addToMonsterMap(Monsters.Evoker);
        this.addToMonsterMap(Monsters.Ravager);
        this.addToMonsterMap(Monsters.Piglin);
        this.addToMonsterMap(Monsters.Husk);
        this.addToMonsterMap(Monsters.Pillager);
        this.addToMonsterMap(Monsters.Breeze);
    }

    public void activate() {
        PlayerInteractionEvents.subscribeLivingDeath(this);
    }

    public void dispose() {
        PlayerInteractionEvents.unsubscribeLivingDeath(this);
    }

    public boolean spawnMonster(Item item, Player player, ItemStack interactionHandItemStack) {
        if (!this.monstersByActionItem.containsKey(item) || this.level == null) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            Level level;
            int shiftX = this.level.random.nextIntBetweenInclusive(-30, 30);
            int shiftZ = this.level.random.nextIntBetweenInclusive(-30, 30);
            BlockPos startPos = this.getBlockPos().offset(shiftX, 0, shiftZ);
            BlockPos pos = null;
            int minY = this.getBlockPos().getY() - 30;
            IMonster monster = this.monstersByActionItem.get(item);
            BlockPos p = startPos.above(30);
            while (p.getY() > minY) {
                if (monster.getSpawnStrategy().canSpawnAtPos(this.level, p, player)) {
                    pos = p;
                    break;
                }
                p = p.below();
            }
            if (pos == null) continue;
            Utils.instance.sound.playSoundByBlock(player, this.getBlockPos(), SoundEvents.DRIPSTONE_BLOCK_PLACE);
            if (this.level.isClientSide() || !((level = this.getLevel()) instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            interactionHandItemStack.setCount(interactionHandItemStack.getCount() - 1);
            ChunkAccess chunk = this.level.getChunk(pos);
            EntityType<? extends Entity> entityType = monster.getEntityType();
            Entity entity = entityType.spawn(serverLevel, interactionHandItemStack, player, pos, MobSpawnType.SPAWNER, true, true);
            if (entity != null) {
                chunk.addEntity(entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Enemy)) {
            return;
        }
        Level blockEntityLevel = this.getLevel();
        if (blockEntityLevel == null || !entity.level().dimension().equals(blockEntityLevel.dimension())) {
            return;
        }
        BlockPos pos = this.getPosition();
        double distance = entity.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (distance < 4900.0) {
            entity.setHealth(1.0f);
            event.setCanceled(true);
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.getBlockPos();
    }

    private void addToMonsterMap(IMonster monster) {
        this.monstersByActionItem.put(monster.getActionItem(), monster);
    }

    public void tick(Level level, BlockPos pos, BlockState blockState, DevilBlockEntity devilBlockEntity) {
        if (level.isClientSide() || level.getGameTime() % 20L != 0L) {
            return;
        }
        int horizRadius = 18;
        int vertRadius = 5;
        for (int i = 0; i < 5; ++i) {
            BlockState leafState;
            BlockPos leafPos;
            int lz;
            int ly;
            int lx;
            int j;
            int dx = random.nextInt(37) - 18;
            int x = pos.getX() + dx;
            int radiusDecrement = Math.max(Math.abs(dx) - 9, 0);
            int newRadius = 18 - radiusDecrement;
            int z = pos.getZ() + random.nextInt((newRadius << 1) + 1) - newRadius;
            int y = pos.getY() + random.nextInt(11) - 5;
            BlockPos targetPos = new BlockPos(x, y, z);
            BlockState targetState = level.getBlockState(targetPos);
            BlockPos abovePos = targetPos.above();
            BlockState aboveState = level.getBlockState(abovePos);
            if (targetState.is(BlockTags.LOGS)) {
                for (j = 0; j < 3; ++j) {
                    lx = targetPos.getX() + random.nextInt(11) - 5;
                    leafPos = new BlockPos(lx, ly = targetPos.getY() + random.nextInt(8) - 2, lz = targetPos.getZ() + random.nextInt(11) - 5);
                    leafState = level.getBlockState(leafPos);
                    if (!leafState.is(BlockTags.LEAVES)) continue;
                    level.destroyBlock(leafPos, true);
                }
                continue;
            }
            if (targetState.is(BlockTags.LEAVES)) {
                level.destroyBlock(targetPos, true);
                for (j = 0; j < 3; ++j) {
                    lx = targetPos.getX() + random.nextInt(11) - 5;
                    leafPos = new BlockPos(lx, ly = targetPos.getY() + random.nextInt(9) - 4, lz = targetPos.getZ() + random.nextInt(11) - 5);
                    leafState = level.getBlockState(leafPos);
                    if (!leafState.is(BlockTags.LEAVES)) continue;
                    level.destroyBlock(leafPos, true);
                }
                continue;
            }
            if (targetState.is(Blocks.DIAMOND_ORE) || targetState.is(Blocks.DEEPSLATE_DIAMOND_ORE)) {
                level.setBlock(targetPos, ((Block)BlockRegistry.GREEN_DIAMOND_ORE.get()).defaultBlockState(), 3);
                continue;
            }
            if (targetState.is(Blocks.OBSIDIAN)) {
                boolean isCrying = random.nextBoolean();
                if (isCrying) {
                    level.setBlock(targetPos, Blocks.CRYING_OBSIDIAN.defaultBlockState(), 3);
                    continue;
                }
                level.setBlock(targetPos, ((Block)BlockRegistry.CRACKED_OBSIDIAN.get()).defaultBlockState(), 3);
                continue;
            }
            if (targetState.is(BlockTags.TERRACOTTA)) {
                level.setBlock(targetPos, Blocks.BLACK_TERRACOTTA.defaultBlockState(), 3);
                continue;
            }
            if (this.isPlant(targetState)) {
                if (i != 0) continue;
                level.destroyBlock(targetPos, true);
                continue;
            }
            if (!aboveState.isAir() && !aboveState.is(Blocks.WATER) && !this.isPlant(aboveState)) continue;
            if (i == 0) {
                if (targetState.is(Blocks.GRASS_BLOCK) || targetState.is(Blocks.PODZOL)) {
                    level.setBlock(targetPos, Blocks.MYCELIUM.defaultBlockState(), 3);
                } else if (targetState.is(Blocks.FARMLAND) || targetState.is(Blocks.DIRT_PATH) || targetState.is(Blocks.DIRT)) {
                    level.setBlock(targetPos, Blocks.MUD.defaultBlockState(), 3);
                } else if (targetState.is(Blocks.STONE)) {
                    isMossy = random.nextBoolean();
                    if (isMossy) {
                        level.setBlock(targetPos, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 3);
                    } else {
                        level.setBlock(targetPos, Blocks.INFESTED_STONE.defaultBlockState(), 3);
                    }
                } else if (targetState.is(Blocks.COBBLESTONE)) {
                    isMossy = random.nextBoolean();
                    if (isMossy) {
                        level.setBlock(targetPos, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 3);
                    } else {
                        level.setBlock(targetPos, Blocks.INFESTED_COBBLESTONE.defaultBlockState(), 3);
                    }
                } else if (targetState.is(Blocks.DEEPSLATE)) {
                    level.setBlock(targetPos, Blocks.INFESTED_DEEPSLATE.defaultBlockState(), 3);
                } else if (targetState.is(Blocks.SAND)) {
                    if (aboveState.is(Blocks.WATER)) {
                        level.setBlock(targetPos, Blocks.CLAY.defaultBlockState(), 3);
                    } else {
                        boolean isEndstone = random.nextBoolean();
                        if (isEndstone) {
                            level.setBlock(targetPos, Blocks.END_STONE.defaultBlockState(), 3);
                        } else {
                            level.setBlock(targetPos, Blocks.TERRACOTTA.defaultBlockState(), 3);
                        }
                    }
                } else if (targetState.is(Blocks.END_STONE)) {
                    level.setBlock(targetPos, ((Block)BlockRegistry.CRACKED_ENDSTONE.get()).defaultBlockState(), 3);
                } else if (targetState.is(BlockTags.ICE)) {
                    level.setBlock(targetPos, Blocks.WATER.defaultBlockState(), 3);
                }
            }
            if (!targetState.is(Blocks.CLAY)) continue;
            level.setBlock(targetPos, Blocks.MUD.defaultBlockState(), 3);
        }
    }

    private boolean isPlant(BlockState blockState) {
        return blockState.getBlock() instanceof BushBlock || blockState.is(Blocks.CACTUS) || blockState.is(Blocks.SUGAR_CANE);
    }
}

