/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.items;

import com.pekar.angelblock.items.ModItemWithDoubleHoverText;
import com.pekar.angelblock.utils.SoundType;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class EndstonePowder
extends ModItemWithDoubleHoverText {
    public InteractionResult useOn(UseOnContext context) {
        BlockPos startPos;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        boolean isClientSide = level.isClientSide();
        switch (facing) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: {
                BlockPos blockPos = pos.above();
                break;
            }
            case NORTH: {
                BlockPos blockPos = pos.north();
                break;
            }
            case SOUTH: {
                BlockPos blockPos = pos.south();
                break;
            }
            case EAST: {
                BlockPos blockPos = pos.east();
                break;
            }
            case WEST: {
                BlockPos blockPos = pos.west();
                break;
            }
            case DOWN: {
                BlockPos blockPos = startPos = pos.above();
            }
        }
        if (level.getBlockState(startPos).getBlock() == Blocks.LAVA) {
            int X = pos.getX();
            int Y = startPos.getY();
            int Z = pos.getZ();
            ArrayList<BlockPos> blocksToTransform = new ArrayList<BlockPos>();
            for (int x = X - 2; x <= X + 2; ++x) {
                for (int z = Z - 2; z <= Z + 2; ++z) {
                    BlockPos currentPos = new BlockPos(x, Y, z);
                    Block upBlock = level.getBlockState(currentPos).getBlock();
                    if (upBlock != Blocks.LAVA || level.getFluidState(currentPos).getAmount() != 8) continue;
                    blocksToTransform.add(currentPos);
                }
            }
            if (!level.isClientSide()) {
                for (BlockPos ps : blocksToTransform) {
                    level.setBlock(ps, Blocks.END_STONE.defaultBlockState(), 11);
                }
                if (player != null) {
                    ItemStack itemStack = player.getItemInHand(context.getHand());
                    itemStack.shrink(1);
                }
            }
            if (!blocksToTransform.isEmpty()) {
                this.utils.sound.playSoundByBlock(player, pos, SoundType.STEAM);
            }
            return isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }
}

