/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.items;

import com.pekar.angelblock.items.ModItem;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.ITooltipProvider;
import com.pekar.angelblock.tooltip.TextStyle;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MarineCrystal
extends ModItem
implements ITooltipProvider {
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand usedHand) {
        Level level = player.level();
        boolean isClientSide = level.isClientSide();
        if (entity instanceof Player) {
            return InteractionResult.FAIL;
        }
        if (usedHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean result = entity.removeAllEffects();
            if (result) {
                level.playSound(null, (Entity)entity, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        return InteractionResult.sidedSuccess((boolean)isClientSide);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        ITooltipProvider.appendHoverText(this, stack, context, components, flag);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 3; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Notice, i == 3).apply();
        }
    }
}

