/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.items;

import com.pekar.angelblock.items.ModItemWithDoubleHoverText;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class MinerFigure
extends ModItemWithDoubleHoverText {
    private static final double EFFECTIVE_RADIUS = 16.0;

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Level level = player.level();
        boolean isClientSide = level.isClientSide();
        if (interactionTarget instanceof Piglin) {
            Piglin piglin = (Piglin)interactionTarget;
            if (!isClientSide) {
                this.eraseMobMemory((Mob)piglin, player);
            }
            this.utils.sound.playSoundByLivingEntity(player, (LivingEntity)player, SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 1.0f, 2.0f);
            return this.getToolInteractionResult(level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        if (this.erasePiglinsMemory(level, pos = context.getClickedPos(), context.getPlayer())) {
            return this.getToolInteractionResult(level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    private boolean erasePiglinsMemory(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide()) {
            List monsters = level.getEntitiesOfClass(Mob.class, new AABB(pos).inflate(16.0), entity -> entity instanceof Piglin || entity instanceof ZombifiedPiglin);
            for (Entity entity2 : monsters) {
                if (!(entity2 instanceof Piglin)) continue;
                Piglin piglin = (Piglin)entity2;
                this.eraseMobMemory((Mob)piglin, player);
            }
            if (!monsters.isEmpty()) {
                level.playSound(player, (Entity)player, SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 1.0f, 2.0f);
            }
            return !monsters.isEmpty();
        }
        return false;
    }

    private void eraseMobMemory(Mob mob, Player player) {
        mob.setLastHurtByMob(null);
        mob.setTarget(null);
        mob.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        mob.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        BlockPos pos;
        if (interactionHand == InteractionHand.MAIN_HAND && this.erasePiglinsMemory(level, pos = player.getOnPos(), player)) {
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(interactionHand), (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand));
    }

    private InteractionResult getToolInteractionResult(boolean isClientSide) {
        return isClientSide ? InteractionResult.SUCCESS_NO_ITEM_USED : InteractionResult.CONSUME_PARTIAL;
    }
}

