/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.network.packets;

import com.pekar.angelblock.network.Packet;
import com.pekar.angelblock.network.ServerToClientPacket;
import com.pekar.angelblock.utils.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PlaySoundPacket
extends ServerToClientPacket {
    private final SoundEvent soundEvent;
    private final float pitch;

    public PlaySoundPacket() {
        this(null, 1.0f);
    }

    public PlaySoundPacket(SoundEvent soundEvent) {
        this(soundEvent, 1.0f);
    }

    public PlaySoundPacket(SoundEvent soundEvent, float pitch) {
        this.soundEvent = soundEvent;
        this.pitch = pitch;
    }

    @Override
    public String getPacketId() {
        return "play_sound";
    }

    @Override
    public Packet decode(FriendlyByteBuf buffer) {
        SoundEvent soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)buffer.readResourceLocation());
        float pitch = buffer.readFloat();
        return new PlaySoundPacket(soundEvent, pitch);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.soundEvent != null ? this.soundEvent.getLocation() : SoundEvents.BONE_MEAL_USE.getLocation());
        buffer.writeFloat(this.pitch);
    }

    @Override
    public void onReceive(IPayloadContext context) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.playSound(this.soundEvent, 1.0f, this.pitch);
        }
    }

    private SoundEvent getSound(SoundType soundType) {
        return switch (soundType) {
            default -> throw new MatchException(null, null);
            case SoundType.PLANT -> SoundEvents.CROP_PLANTED;
            case SoundType.BLOCK_CHANGED -> SoundEvents.STONE_BREAK;
            case SoundType.WATER_PLACED -> SoundEvents.PLAYER_SPLASH_HIGH_SPEED;
            case SoundType.LAVA_PLACED -> SoundEvents.LAVA_POP;
            case SoundType.STEAM -> SoundEvents.LAVA_EXTINGUISH;
            case SoundType.AMETHYST_FOUND -> (SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value();
            case SoundType.DIAMOND_FOUND -> (SoundEvent)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE.value();
            case SoundType.ORE_FOUND -> SoundEvents.GRAVEL_PLACE;
            case SoundType.SCULK_FOUND -> SoundEvents.SCULK_CLICKING;
            case SoundType.INFESTED_BLOCK -> SoundEvents.SILVERFISH_DEATH;
            case SoundType.BONEMEAL -> SoundEvents.BONE_MEAL_USE;
            case SoundType.RAIL_PLACED -> SoundEvents.METAL_PLACE;
            case SoundType.REDSTONE_WIRE_PLACED, SoundType.STONE_PLACED -> SoundEvents.STONE_PLACE;
            case SoundType.WOOD_PLACED -> SoundEvents.WOOD_PLACE;
            case SoundType.RAILS_FOUND -> SoundEvents.ANVIL_LAND;
            case SoundType.MINECRAFT -> this.soundEvent;
            case SoundType.UNDEFINED -> null;
        };
    }
}

