/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.tools.DetectorFlags;
import com.pekar.angelblock.tools.FireRod;
import com.pekar.angelblock.tools.ToolRegistry;
import com.pekar.angelblock.utils.SoundType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AmethystRod
extends FireRod {
    public AmethystRod(Tier material, boolean isMagnetic, Item.Properties properties) {
        super(material, isMagnetic, properties);
    }

    @Override
    protected InteractionResult useOnInternal(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = player.level();
        InteractionResult result = super.useOnInternal(context);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ItemStack itemStack = player.getItemInHand(context.getHand());
        boolean isClientSide = level.isClientSide();
        if (!this.hasCriticalDamage(itemStack)) {
            BlockPos pos = context.getClickedPos();
            BlockState blockState = level.getBlockState(pos);
            Block block = blockState.getBlock();
            BlockPos upPos = pos.above();
            Block upBlock = level.getBlockState(upPos).getBlock();
            if (block == Blocks.OBSIDIAN && upBlock != Blocks.LAVA) {
                if (!isClientSide) {
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                    this.setBlock(player, pos, Blocks.CRYING_OBSIDIAN);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.STONE || block == Blocks.GRANITE || block == Blocks.ANDESITE || block == Blocks.DIORITE || block == Blocks.DRIPSTONE_BLOCK) {
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                return this.setOnBlockSide(context, this::setGlowLichen);
            }
            if (block == Blocks.DIAMOND_BLOCK) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.BUDDING_AMETHYST);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.BONE_BLOCK) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.CALCITE);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    private String getRodId() {
        return ToolRegistry.AMETHYST_ROD.getRegisteredName();
    }

    @Override
    protected void appendPlacingBlockInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        super.appendPlacingBlockInfo(tooltipComponents, false);
        for (int i = 2; i <= 2; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, selectAsNew, false));
        }
    }

    @Override
    protected void appendBlockTransformInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        super.appendBlockTransformInfo(tooltipComponents, false);
        for (int i = 9; i <= 11; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, selectAsNew, false));
        }
    }

    @Override
    protected void appendMagneticInfo(List<Component> tooltipComponents) {
        for (int i = 13; i <= 21; ++i) {
            if (i == 21) {
                tooltipComponents.add((Component)Component.empty());
            }
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, i == 13, false, false, false, false, i == 21));
        }
    }

    @Override
    protected void appendCommonPostInfo(List<Component> tooltipComponents) {
        for (int i = 22; i <= 23; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, false, i == 22));
        }
    }

    @Override
    protected void oreFoundEvent(ServerPlayer player, BlockPos pos, DetectorFlags detectorFlags) {
        SoundType soundType;
        if (detectorFlags.isSculkVeinFound()) {
            soundType = SoundType.SCULK_FOUND;
        } else if (detectorFlags.isDiamondOreFound()) {
            soundType = SoundType.DIAMOND_FOUND;
        } else if (detectorFlags.isAmethystFound()) {
            soundType = SoundType.AMETHYST_FOUND;
        } else if (detectorFlags.isRailsFound()) {
            soundType = SoundType.RAILS_FOUND;
        } else if (detectorFlags.isShiftingOreFound()) {
            soundType = SoundType.ORE_FOUND;
        } else {
            return;
        }
        this.utils.sound.playSoundOnBothSides(player, pos, soundType, SoundSource.BLOCKS, 5.0f);
    }

    @Override
    protected int getOreDepth() {
        return 12;
    }

    @Override
    protected int getSculkDetectionDepth() {
        return 128;
    }

    private InteractionResult setGlowLichen(BlockPlaceContext context, BlockPos pos) {
        Level level = context.getLevel();
        BlockState state = Blocks.GLOW_LICHEN.getStateForPlacement(context);
        if (!level.isEmptyBlock(pos)) {
            return InteractionResult.FAIL;
        }
        boolean isClientSide = context.getLevel().isClientSide();
        if (!isClientSide && state != null) {
            level.setBlock(pos, state, 11);
        }
        this.utils.sound.playSoundByBlock(context.getPlayer(), pos, SoundType.BLOCK_CHANGED);
        return this.getToolInteractionResult(true, isClientSide);
    }
}

