/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.blocks.GreenDiamondBlock;
import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.FireRod;
import com.pekar.angelblock.tools.MagneticRod;
import com.pekar.angelblock.tools.ToolRegistry;
import com.pekar.angelblock.utils.SoundType;
import com.pekar.angelblock.utils.Utils;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AncientRod
extends MagneticRod {
    public AncientRod(Tier material, boolean isMagnetic, Item.Properties properties) {
        super(material, isMagnetic, properties);
    }

    @Override
    protected void additionalActionOnMineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos pos, LivingEntity entity) {
        if (blockState.getBlock() == Blocks.COBWEB && !level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            this.destroyWebBlocks(level, pos);
            this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
        }
    }

    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (this.hasCriticalDamage(itemStack)) {
            return 1.0f;
        }
        if (blockState.getBlock() == Blocks.COBWEB) {
            return 18.0f;
        }
        return super.getDestroySpeed(itemStack, blockState);
    }

    @Override
    protected InteractionResult useOnInternal(UseOnContext context) {
        InteractionResult result = super.useOnInternal(context);
        if (result == InteractionResult.FAIL) {
            return result;
        }
        Player player = context.getPlayer();
        if (this.isEnhanced() && player != null && player.hasEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT)) {
            return result;
        }
        Level level = player.level();
        boolean isClientSide = level.isClientSide();
        BlockPos pos = context.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if ((block != Blocks.STONE || context.getClickedFace() == Direction.UP) && this.utils.blocks.transformations.mossyTransforming(player, pos, block)) {
            return this.getToolInteractionResult(true, isClientSide);
        }
        ItemStack itemStack = player.getItemInHand(context.getHand());
        if (!this.hasCriticalDamage(itemStack)) {
            if (block instanceof InfestedBlock) {
                InfestedBlock infestedBlock = (InfestedBlock)block;
                if (!isClientSide) {
                    this.setBlock(player, pos, infestedBlock.getHostBlock());
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.DIAMOND_ORE || block == Blocks.DEEPSLATE_DIAMOND_ORE) {
                if (!isClientSide) {
                    boolean isDark = block == Blocks.DEEPSLATE_DIAMOND_ORE;
                    this.setBlock(player, pos, (BlockState)((Block)BlockRegistry.GREEN_DIAMOND_ORE.get()).defaultBlockState().setValue((Property)GreenDiamondBlock.IS_DARK, (Comparable)Boolean.valueOf(isDark)));
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block instanceof LeavesBlock) {
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                return this.setOnBlockSide(context, this::setVine);
            }
            InteractionHand hand = context.getHand();
            Direction facing = context.getClickedFace();
            Random itemRand = new Random();
            if (facing == Direction.UP && level.isEmptyBlock(pos.above())) {
                if (this.utils.blocks.conditions.isNearWaterHorizontal(level, pos) && (block == Blocks.DIRT || block == Blocks.COARSE_DIRT || block == Blocks.GRASS_BLOCK || block == Blocks.PODZOL || this.utils.blocks.types.isSandBlock(block) || block == Blocks.MOSS_BLOCK || block == Blocks.MYCELIUM)) {
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                    return this.plant(player, level, pos, hand, facing, Blocks.SUGAR_CANE);
                }
                if (block == Blocks.DIRT || block == Blocks.COARSE_DIRT || block == Blocks.MOSS_BLOCK) {
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                    int randomValue = itemRand.nextInt() & 1;
                    switch (randomValue) {
                        case 0: {
                            return this.plant(player, level, pos, hand, facing, Blocks.SWEET_BERRY_BUSH);
                        }
                    }
                    return this.plant(player, level, pos, hand, facing, Blocks.FERN);
                }
                if (block == Blocks.GRASS_BLOCK) {
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                    int randomValue = itemRand.nextInt(16);
                    return this.plant(player, level, pos, hand, facing, this.chooseFlowerByValue(randomValue));
                }
                if (block == Blocks.SAND) {
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                    return this.plant(player, level, pos, hand, facing, Blocks.CACTUS);
                }
                if (block == Blocks.FARMLAND) {
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                    int randomValue = itemRand.nextInt() % 4;
                    switch (randomValue) {
                        case 0: {
                            return this.plant(player, level, pos, hand, facing, Blocks.WHEAT);
                        }
                        case 1: {
                            return this.plant(player, level, pos, hand, facing, Blocks.POTATOES);
                        }
                        case 2: {
                            return this.plant(player, level, pos, hand, facing, Blocks.CARROTS);
                        }
                    }
                    return this.plant(player, level, pos, hand, facing, Blocks.BEETROOTS);
                }
                if (block == Blocks.DIRT_PATH) {
                    if (!isClientSide) {
                        this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                        this.setBlock(player, pos, Blocks.GRASS_BLOCK);
                    }
                    return this.getToolInteractionResult(true, isClientSide);
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        Block block = state.getBlock();
        return !this.hasCriticalDamage(stack) && block == Blocks.COBWEB;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.showExtendedDescription(tooltipComponents)) {
            return;
        }
        this.appendCommonPreInfo(tooltipComponents);
        if (Screen.hasControlDown()) {
            if (!this.isEnhanced()) {
                tooltipComponents.add((Component)Component.translatable((String)"description.rods.no_magnet_mode").withStyle(ChatFormatting.DARK_RED));
            } else if (this instanceof FireRod) {
                tooltipComponents.add((Component)Component.translatable((String)"description.rods.magnet_mode.fire_rod").withStyle(ChatFormatting.DARK_GRAY));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"description.rods.magnet_mode.ancient_rod").withStyle(ChatFormatting.DARK_GRAY));
            }
            this.appendMagneticInfo(tooltipComponents);
        } else if (Screen.hasShiftDown()) {
            this.appendPlacingBlockInfo(tooltipComponents, true);
            tooltipComponents.add((Component)Component.empty());
        } else if (Screen.hasAltDown()) {
            this.appendBlockTransformInfo(tooltipComponents, true);
            tooltipComponents.add((Component)Component.empty());
        }
        this.appendCommonPostInfo(tooltipComponents);
        tooltipComponents.add((Component)Component.empty());
        if (Screen.hasControlDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"description.rods.press_shift"));
            tooltipComponents.add((Component)Component.translatable((String)"description.rods.press_alt"));
        } else if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"description.rods.press_alt"));
            tooltipComponents.add((Component)Component.translatable((String)"description.rods.press_ctrl"));
        } else if (Screen.hasAltDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"description.rods.press_shift"));
            tooltipComponents.add((Component)Component.translatable((String)"description.rods.press_ctrl"));
        }
    }

    private String getRodId() {
        return ToolRegistry.ANCIENT_ROD.getRegisteredName();
    }

    protected MutableComponent getDescription(String rodId, int lineNumber, boolean isHeader, boolean isSubHeader, boolean isNotice, boolean isImportantNotice, boolean isSelectedText, boolean isDarkGray) {
        String descriptionId = "item." + rodId.replace(':', '.');
        MutableComponent component = Component.translatable((String)(descriptionId + ".desc" + lineNumber));
        MutableComponent formattedComponent = Utils.instance.text.getFormattedTextComponent(component, isHeader, isSubHeader, isNotice, isImportantNotice, isDarkGray);
        return isSelectedText ? formattedComponent.withStyle(ChatFormatting.WHITE) : formattedComponent;
    }

    protected void appendPlacingBlockInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        for (int i = 1; i <= 8; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, i == 1 || i == 3, false, false, false, false, false));
        }
    }

    protected void appendBlockTransformInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        for (int i = 9; i <= 12; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, i == 9, false, false, false, false, false));
        }
    }

    protected void appendMagneticInfo(List<Component> tooltipComponents) {
        for (int i = 13; i <= 21; ++i) {
            if (i == 21) {
                tooltipComponents.add((Component)Component.empty());
            }
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, i == 13, false, false, false, false, i == 21));
        }
    }

    protected void appendCommonPreInfo(List<Component> tooltipComponents) {
        tooltipComponents.add((Component)this.getDescription(0, false));
        if (this.isEnhanced()) {
            tooltipComponents.add((Component)this.getDescription(1, false));
        }
    }

    protected void appendCommonPostInfo(List<Component> tooltipComponents) {
        for (int i = 22; i <= 23; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, false, i == 22));
        }
    }

    private void destroyWebBlocks(Level level, BlockPos pos) {
        int X = pos.getX();
        int Y = pos.getY();
        int Z = pos.getZ();
        for (int a = X - 1; a <= X + 1; ++a) {
            for (int b = Y - 1; b <= Y + 1; ++b) {
                for (int c = Z - 1; c <= Z + 1; ++c) {
                    BlockPos localPos = new BlockPos(a, b, c);
                    Block block = level.getBlockState(localPos).getBlock();
                    if (block != Blocks.COBWEB) continue;
                    level.destroyBlock(localPos, true);
                }
            }
        }
    }

    private InteractionResult setVine(BlockPlaceContext context, BlockPos pos) {
        Level level = context.getLevel();
        BlockState state = Blocks.VINE.getStateForPlacement(context);
        if (!level.isEmptyBlock(pos)) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide() && state != null) {
            level.setBlock(pos, state, 11);
        }
        this.utils.sound.playSoundByBlock(context.getPlayer(), pos, SoundType.PLANT);
        return this.getToolInteractionResult(true, level.isClientSide());
    }

    protected InteractionResult setOnBlockSide(UseOnContext useOnContext, BiFunction<BlockPlaceContext, BlockPos, InteractionResult> setBlock) {
        BlockPlaceContext context = new BlockPlaceContext(useOnContext);
        BlockPos pos = useOnContext.getClickedPos();
        Direction facing = useOnContext.getClickedFace();
        switch (facing) {
            case UP: {
                return InteractionResult.FAIL;
            }
            case NORTH: {
                return setBlock.apply(context, pos.north());
            }
            case SOUTH: {
                return setBlock.apply(context, pos.south());
            }
            case EAST: {
                return setBlock.apply(context, pos.east());
            }
            case WEST: {
                return setBlock.apply(context, pos.west());
            }
            case DOWN: {
                return setBlock.apply(context, pos.below());
            }
        }
        return InteractionResult.PASS;
    }

    private Block chooseFlowerByValue(int value) {
        switch (value) {
            case 1: {
                return Blocks.POPPY;
            }
            case 2: {
                return Blocks.BLUE_ORCHID;
            }
            case 3: {
                return Blocks.ALLIUM;
            }
            case 4: {
                return Blocks.AZURE_BLUET;
            }
            case 5: {
                return Blocks.RED_TULIP;
            }
            case 6: {
                return Blocks.ORANGE_TULIP;
            }
            case 7: {
                return Blocks.WHITE_TULIP;
            }
            case 8: {
                return Blocks.PINK_TULIP;
            }
            case 9: {
                return Blocks.OXEYE_DAISY;
            }
            case 10: {
                return Blocks.CORNFLOWER;
            }
            case 11: {
                return Blocks.LILY_OF_THE_VALLEY;
            }
            case 12: {
                return Blocks.SUNFLOWER;
            }
            case 13: {
                return Blocks.LILAC;
            }
            case 14: {
                return Blocks.ROSE_BUSH;
            }
            case 15: {
                return Blocks.PEONY;
            }
        }
        return Blocks.DANDELION;
    }
}

