/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.ModAxe;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EnhancedAxe
extends ModAxe {
    public EnhancedAxe(Tier material, float attackDamage, float attackSpeed, Item.Properties properties, IMaterialProperties materialProperties) {
        super(material, attackDamage, attackSpeed, properties, materialProperties);
    }

    @Override
    public boolean isEnhanced() {
        return true;
    }

    public boolean mineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos pos, LivingEntity livingEntity) {
        this.mineAdditionalBlocks(level, pos, livingEntity);
        return super.mineBlock(itemStack, level, blockState, pos, livingEntity);
    }

    protected void mineAdditionalBlocks(Level level, BlockPos pos, LivingEntity entityLiving) {
        if (!entityLiving.hasEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT)) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!this.isToolEffective(entityLiving, pos)) {
            return;
        }
        if (blockState.hasBlockEntity() || blockState != block.defaultBlockState() && !this.isCompatiblePlant(block)) {
            return;
        }
        float originHardness = block.defaultDestroyTime();
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int y = posY - 1; y <= posY + 1; ++y) {
                for (int z = posZ - 1; z <= posZ + 1; ++z) {
                    if (x == posX && y == posY && z == posZ) continue;
                    this.onBlockMining(level, blockState, originHardness, new BlockPos(x, y, z), entityLiving);
                }
            }
        }
    }

    protected boolean isCompatiblePlant(Block block) {
        return block instanceof BushBlock;
    }

    protected void onBlockMining(Level level, BlockState originBlockState, float originHardness, BlockPos pos, LivingEntity entityLiving) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (blockState.hasBlockEntity() || blockState != block.defaultBlockState() && !this.isCompatiblePlant(block)) {
            return;
        }
        float hardness = block.defaultDestroyTime();
        if (hardness <= originHardness && this.isToolEffective(entityLiving, pos) && (this.materialProperties.isSafeToBreak(entityLiving, pos) || entityLiving.isShiftKeyDown()) && this.utils.player.destroyBlockByMainHandTool(level, pos, entityLiving, blockState, block)) {
            this.damageMainHandItem(1, entityLiving);
        }
    }
}

