/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.DetectorFlags;
import com.pekar.angelblock.tools.MarineRod;
import com.pekar.angelblock.tools.ToolRegistry;
import com.pekar.angelblock.utils.SoundType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FireRod
extends MarineRod {
    public FireRod(Tier material, boolean isMagnetic, Item.Properties properties) {
        super(material, isMagnetic, properties);
    }

    @Override
    protected InteractionResult useOnInternal(UseOnContext context) {
        InteractionResult result;
        Player player = context.getPlayer();
        Level level = player.level();
        if (this.isEnhanced() && player.hasEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT)) {
            return super.useOnInternal(context);
        }
        InteractionHand interactionHand = context.getHand();
        ItemStack itemStack = player.getItemInHand(interactionHand);
        boolean isBroken = this.hasCriticalDamage(itemStack);
        boolean isClientSide = level.isClientSide();
        BlockPos pos = context.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!isBroken) {
            Direction facing = context.getClickedFace();
            if (facing == Direction.UP) {
                if (block == Blocks.SOUL_SAND && level.isEmptyBlock(pos.above())) {
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                    return this.plant(player, level, pos, interactionHand, facing, Blocks.NETHER_WART);
                }
            } else if (block == Blocks.END_STONE) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.NETHERRACK);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
        }
        if ((result = super.useOnInternal(context)) != InteractionResult.PASS) {
            return result;
        }
        if (!isBroken) {
            if (block == Blocks.MAGMA_BLOCK) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.GLOWSTONE);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.GLOWSTONE) {
                if (!isClientSide) {
                    level.setBlock(pos, ((Block)BlockRegistry.DESTROYING_BLAZE_POWDER.get()).defaultBlockState(), 0);
                    level.destroyBlock(pos, true, (Entity)player, 1);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.BASALT) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.BLACKSTONE);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.WARPED_STEM || block == Blocks.CRIMSON_STEM) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.SHROOMLIGHT);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
            if (block == Blocks.CLAY) {
                if (!isClientSide) {
                    this.setBlock(player, pos, Blocks.TERRACOTTA);
                    this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
                }
                return this.getToolInteractionResult(true, isClientSide);
            }
        }
        return result;
    }

    private String getRodId() {
        return ToolRegistry.FIRE_ROD.getRegisteredName();
    }

    @Override
    protected void appendPlacingBlockInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        super.appendPlacingBlockInfo(tooltipComponents, false);
        for (int i = 2; i <= 3; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, selectAsNew, false));
        }
    }

    @Override
    protected void appendBlockTransformInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        super.appendBlockTransformInfo(tooltipComponents, false);
        for (int i = 7; i <= 12; ++i) {
            MutableComponent component = this.getDescription(this.getRodId(), i, false, false, false, false, selectAsNew, false);
            if (component.getString().isEmpty()) continue;
            tooltipComponents.add((Component)component);
        }
    }

    @Override
    protected void appendMagneticInfo(List<Component> tooltipComponents) {
        for (int i = 14; i <= 22; ++i) {
            if (i == 22) {
                tooltipComponents.add((Component)Component.empty());
            }
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, i == 14, false, false, false, false, i == 22));
        }
    }

    @Override
    protected void appendCommonPostInfo(List<Component> tooltipComponents) {
        for (int i = 23; i <= 24; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, false, i == 23));
        }
    }

    @Override
    protected boolean canBeReplaced(Level level, BlockPos pos) {
        TagKey replaceables;
        BlockState blockState = level.getBlockState(pos);
        return blockState.is(replaceables = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"nether_replaceables"))) || super.canBeReplaced(level, pos);
    }

    @Override
    protected boolean isShiftingOre(Level level, BlockPos pos) {
        TagKey netherShiftingOres;
        BlockState blockState = level.getBlockState(pos);
        return blockState.is(netherShiftingOres = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"nether_shifting_ores"))) || super.isShiftingOre(level, pos);
    }

    @Override
    protected int getShiftingRadius() {
        return 2;
    }

    @Override
    protected int getOreDepth() {
        return 9;
    }

    @Override
    protected int getAmethystDetectionDepth() {
        return 40;
    }

    @Override
    protected void oreFoundEvent(ServerPlayer player, BlockPos pos, DetectorFlags detectorFlags) {
        SoundType soundType;
        if (detectorFlags.isSculkVeinFound()) {
            soundType = SoundType.SCULK_FOUND;
        } else if (detectorFlags.isDiamondOreFound()) {
            soundType = SoundType.DIAMOND_FOUND;
        } else if (detectorFlags.isAmethystFound()) {
            soundType = SoundType.AMETHYST_FOUND;
        } else if (detectorFlags.isShiftingOreFound()) {
            soundType = SoundType.ORE_FOUND;
        } else {
            return;
        }
        this.utils.sound.playSoundOnBothSides(player, pos, soundType, SoundSource.BLOCKS, 5.0f);
    }
}

