/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.tools.IModToolEnhanceable;
import com.pekar.angelblock.tools.properties.DefaultMaterialProperties;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import com.pekar.angelblock.utils.Utils;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;

public class ModAxe
extends AxeItem
implements IModToolEnhanceable {
    protected final IMaterialProperties materialProperties;
    protected final Utils utils = new Utils();

    public static ModAxe createPrimary(Tier material, float attackDamage, float attackSpeed, Item.Properties properties) {
        return new ModAxe(material, attackDamage, attackSpeed, properties, new DefaultMaterialProperties());
    }

    public ModAxe(Tier material, float attackDamage, float attackSpeed, Item.Properties properties, IMaterialProperties materialProperties) {
        super(material, properties.attributes(AxeItem.createAttributes((Tier)material, (float)attackDamage, (float)attackSpeed)));
        this.materialProperties = materialProperties;
    }

    @Override
    public boolean isTool() {
        return true;
    }

    @Override
    public TieredItem getTool() {
        return this;
    }

    @Override
    public IMaterialProperties getMaterialProperties() {
        return this.materialProperties;
    }

    public void setDamage(ItemStack stack, int damage) {
        int modifiedDamage = Mth.clamp((int)damage, (int)0, (int)(stack.getMaxDamage() - this.getCriticalDurability()));
        stack.set(DataComponents.DAMAGE, (Object)modifiedDamage);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return !this.hasCriticalDamage(stack) && super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.hasCriticalDamage(stack)) {
            return 1.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return !this.hasCriticalDamage(stack) && super.canPerformAction(stack, itemAbility);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.utils.text.showExtendedDescription(tooltipComponents)) {
            return;
        }
        for (int i = 0; i <= 2; ++i) {
            tooltipComponents.add((Component)this.getDescription(i, false, false, false, false, i == 1));
        }
    }
}

