/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.tools.IModToolEnhanceable;
import com.pekar.angelblock.tools.properties.DefaultMaterialProperties;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import com.pekar.angelblock.utils.SoundType;
import com.pekar.angelblock.utils.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;

public class ModHoe
extends HoeItem
implements IModToolEnhanceable {
    protected final IMaterialProperties materialProperties;
    protected final Utils utils = new Utils();

    public static ModHoe createPrimary(Tier material, int attackDamage, float attackSpeed, Item.Properties properties) {
        return new ModHoe(material, attackDamage, attackSpeed, properties, new DefaultMaterialProperties());
    }

    public ModHoe(Tier material, int attackDamage, float attackSpeed, Item.Properties properties, IMaterialProperties materialProperties) {
        super(material, properties.attributes(HoeItem.createAttributes((Tier)material, (float)attackDamage, (float)attackSpeed)));
        this.materialProperties = materialProperties;
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result = super.useOn(context);
        if (result == InteractionResult.FAIL) {
            return result;
        }
        Player player = context.getPlayer();
        Level level = player.level();
        BlockPos pos = context.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        BlockPos upPos = pos.above();
        if (level.isWaterAt(upPos) || level.isEmptyBlock(upPos) && (this.utils.blocks.types.isFarmTypeBlock(level, upPos.north()) && this.utils.blocks.types.isFarmTypeBlock(level, upPos.south()) || this.utils.blocks.types.isFarmTypeBlock(level, upPos.east()) && this.utils.blocks.types.isFarmTypeBlock(level, upPos.west()))) {
            if (!level.isClientSide) {
                level.setBlock(upPos, Blocks.WATER.defaultBlockState(), 11);
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            }
            this.utils.sound.playSoundByBlock(player, pos, SoundType.WATER_PLACED);
            return this.getToolInteractionResult(true, level.isClientSide());
        }
        if (level.isEmptyBlock(upPos) && context.getClickedFace() == Direction.UP) {
            return this.changePodzolToDirt(player, level, pos) ? this.getToolInteractionResult(true, level.isClientSide()) : result;
        }
        return result;
    }

    public void setDamage(ItemStack stack, int damage) {
        int modifiedDamage = Mth.clamp((int)damage, (int)0, (int)(stack.getMaxDamage() - this.getCriticalDurability()));
        stack.set(DataComponents.DAMAGE, (Object)modifiedDamage);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return !this.hasCriticalDamage(stack) && super.canPerformAction(stack, itemAbility);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.utils.text.showExtendedDescription(tooltipComponents)) {
            return;
        }
        for (int i = 0; i <= 5; ++i) {
            tooltipComponents.add((Component)this.getDescription(i, i == 1, false, false, false, i == 4));
        }
    }

    protected boolean changePodzolToDirt(Player player, Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block == Blocks.PODZOL) {
            if (!level.isClientSide) {
                this.setBlock(player, pos, Blocks.DIRT);
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            }
            this.utils.sound.playSoundByBlock(player, pos, SoundEvents.HOE_TILL);
            return true;
        }
        return false;
    }

    @Override
    public boolean isTool() {
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return !this.hasCriticalDamage(stack) && super.isCorrectToolForDrops(stack, state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.hasCriticalDamage(stack)) {
            return 1.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    @Override
    public TieredItem getTool() {
        return this;
    }

    @Override
    public IMaterialProperties getMaterialProperties() {
        return this.materialProperties;
    }
}

