/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.EnhancedAxe;
import com.pekar.angelblock.tools.properties.SuperAxeProperties;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SuperAxe
extends EnhancedAxe {
    public SuperAxe(Tier material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties, new SuperAxeProperties());
    }

    @Override
    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (this.hasCriticalDamage(itemStack)) {
            return 1.0f;
        }
        if (blockState.getBlock() == Blocks.CACTUS) {
            return 12.0f;
        }
        return super.getDestroySpeed(itemStack, blockState);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.utils.text.showExtendedDescription(tooltipComponents)) {
            return;
        }
        for (int i = 0; i <= 10; ++i) {
            tooltipComponents.add((Component)this.getDescription(i, i == 1, false, i == 6, false, i == 9));
        }
    }

    @Override
    protected void mineAdditionalBlocks(Level level, BlockPos pos, LivingEntity entityLiving) {
        if (!this.isEnhanced() || !entityLiving.hasEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT)) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!this.isToolEffective(entityLiving, pos)) {
            return;
        }
        float initialHardness = block.defaultDestroyTime();
        if (initialHardness != 0.0f && !this.isCompatiblePlant(block)) {
            int increment = 1;
            while (this.canProceed(entityLiving, pos.above(increment))) {
                this.onBlockMining(level, blockState, initialHardness, pos.above(increment++), entityLiving);
            }
            increment = 1;
            while (this.canProceed(entityLiving, pos.below(increment))) {
                this.onBlockMining(level, blockState, initialHardness, pos.below(increment++), entityLiving);
            }
        }
        super.mineAdditionalBlocks(level, pos, entityLiving);
    }

    private boolean canProceed(LivingEntity entityLiving, BlockPos pos) {
        return !entityLiving.level().isEmptyBlock(pos) && this.isToolEffective(entityLiving, pos);
    }
}

