/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.utils;

import com.pekar.angelblock.utils.SoundType;
import com.pekar.angelblock.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTransformations {
    BlockTransformations() {
    }

    public boolean mossyTransforming(Player player, BlockPos pos, Block block) {
        boolean isClientSide = player.level().isClientSide();
        if (block == Blocks.STONE || block == Blocks.COBBLESTONE || block == Blocks.COBBLED_DEEPSLATE || block == Blocks.DEEPSLATE) {
            if (!isClientSide) {
                this.setBlock(player, pos, Blocks.MOSSY_COBBLESTONE);
            }
            return true;
        }
        if (block == Blocks.MOSSY_COBBLESTONE) {
            if (!isClientSide) {
                Block resultBlock = pos.getY() > 4 ? Blocks.COBBLESTONE : Blocks.COBBLED_DEEPSLATE;
                this.setBlock(player, pos, resultBlock);
            }
            return true;
        }
        if (block == Blocks.COBBLESTONE_SLAB || block == Blocks.STONE_SLAB) {
            if (!isClientSide) {
                this.setBlock(player, pos, Blocks.MOSSY_COBBLESTONE_SLAB);
            }
            return true;
        }
        if (block == Blocks.MOSSY_COBBLESTONE_SLAB) {
            if (!isClientSide) {
                this.setBlock(player, pos, Blocks.COBBLESTONE_SLAB);
            }
            return true;
        }
        if (block == Blocks.STONE_BRICKS || block == Blocks.DEEPSLATE_BRICKS) {
            if (!isClientSide) {
                this.setBlock(player, pos, Blocks.MOSSY_STONE_BRICKS);
            }
            return true;
        }
        if (block == Blocks.MOSSY_STONE_BRICKS) {
            if (!isClientSide) {
                Block resultBlock = pos.getY() > 4 ? Blocks.STONE_BRICKS : Blocks.DEEPSLATE_BRICKS;
                this.setBlock(player, pos, resultBlock);
            }
            return true;
        }
        if (block == Blocks.STONE_BRICK_SLAB || block == Blocks.DEEPSLATE_BRICK_SLAB) {
            if (!isClientSide) {
                this.setBlock(player, pos, Blocks.MOSSY_STONE_BRICK_SLAB);
            }
            return true;
        }
        if (block == Blocks.MOSSY_STONE_BRICK_SLAB) {
            if (!isClientSide) {
                Block resultBlock = pos.getY() > 4 ? Blocks.STONE_BRICK_SLAB : Blocks.DEEPSLATE_BRICK_SLAB;
                this.setBlock(player, pos, resultBlock);
            }
            return true;
        }
        return false;
    }

    public void setMyceliumInRadius(Level level, BlockPos centerPos, int radius) {
        int posX = centerPos.getX();
        int posY = centerPos.getY();
        int posZ = centerPos.getZ();
        for (int x = posX - radius; x <= posX + radius; ++x) {
            block1: for (int z = posZ - radius; z <= posZ + radius; ++z) {
                for (int y = posY + radius; y >= posY - radius; --y) {
                    boolean canTurnIntoMossyCobleStone;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockState currentBlockState = level.getBlockState(currentPos);
                    Block currentBlock = currentBlockState.getBlock();
                    boolean canTurnIntoMycelium = currentBlock == Blocks.GRASS_BLOCK || currentBlock == Blocks.DIRT;
                    boolean bl = canTurnIntoMossyCobleStone = currentBlock == Blocks.COBBLESTONE || currentBlock == Blocks.STONE;
                    if (!canTurnIntoMycelium && !canTurnIntoMossyCobleStone || level.getBlockState(currentPos.above()).getBlock() != Blocks.GRASS_BLOCK) continue;
                    Block upper2Block = level.getBlockState(currentPos.above(2)).getBlock();
                    if (!level.isEmptyBlock(currentPos.above(2)) && upper2Block != Blocks.BROWN_MUSHROOM && upper2Block != Blocks.RED_MUSHROOM) continue;
                    if (canTurnIntoMycelium) {
                        level.setBlock(currentPos, Blocks.MYCELIUM.defaultBlockState(), 11);
                        continue block1;
                    }
                    level.setBlock(currentPos, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), 11);
                    continue block1;
                }
            }
        }
    }

    private void setBlock(Player player, BlockPos pos, Block block) {
        player.level().setBlock(pos, block.defaultBlockState(), 11);
        Utils.instance.sound.playSoundByBlock(player, pos, SoundType.BLOCK_CHANGED);
    }
}

