/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.recipe;

import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.jetbrains.annotations.NotNull;

public abstract class FilteringPotionIngredient
implements ICustomIngredient {
    private final Predicate<ItemStack> condition;
    private final Item potionGroup;
    private final Holder<Potion> potionType;

    private FilteringPotionIngredient(Predicate<ItemStack> condition, Item potionGroup, Holder<Potion> potionType) {
        this.condition = condition;
        this.potionGroup = potionGroup;
        this.potionType = potionType;
    }

    protected FilteringPotionIngredient(Item potionGroup, Holder<Potion> potionType) {
        this(stack -> {
            if (stack.isEmpty() || stack.getItem() != potionGroup) {
                return false;
            }
            PotionContents contents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            return contents.potion().flatMap(holder -> holder.unwrapKey().map(ResourceKey::location)).equals(potionType.unwrapKey().map(ResourceKey::location));
        }, potionGroup, potionType);
    }

    public boolean test(@NotNull ItemStack stack) {
        return this.condition.test(stack);
    }

    @NotNull
    public Stream<Holder<Item>> items() {
        ItemStack itemStack = new ItemStack((ItemLike)this.potionGroup);
        itemStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(this.potionType));
        return Stream.of(itemStack.getItemHolder());
    }

    public boolean isSimple() {
        return false;
    }
}

