/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.WorkRod;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockState;

public class Builder
extends WorkRod {
    public Builder(ModToolMaterial material, Item.Properties properties) {
        super(material, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        int offHandItemCountAfterUse;
        InteractionResult result;
        Player player = context.getPlayer();
        Level level = player.level();
        ItemStack offHandItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        int offHandItemCountBeforeUse = offHandItemStack.getCount();
        BlockPos pos = context.getClickedPos();
        Item offHandItem = offHandItemStack.getItem();
        boolean success = false;
        if (offHandItem instanceof BlockItem) {
            boolean isMagneticMode = this.isEnhanced() && player.hasEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT);
            boolean bl = success = isMagneticMode ? this.placeBlocksMagnetic(player, level, pos, context.getClickedFace()) : this.placeBlocks(player, level, pos, context.getClickedFace());
        }
        if (((result = this.getToolInteractionResult(success, level.isClientSide())) == InteractionResult.SUCCESS_SERVER || result == InteractionResult.SUCCESS) && (offHandItemCountAfterUse = offHandItemStack.getCount()) < offHandItemCountBeforeUse) {
            this.causePlayerExhaustion(player);
        }
        return result;
    }

    protected boolean placeBlocks(Player player, Level level, BlockPos pos, Direction facing) {
        ItemStack offHandItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        Item item = offHandItemStack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block placingBlock = blockItem.getBlock();
        boolean isPlacingBlockCompatible = this.isBlockCompatible(placingBlock.defaultBlockState());
        BlockState clickedBlockState = level.getBlockState(pos);
        Block clickedBlock = clickedBlockState.getBlock();
        if (!isPlacingBlockCompatible) {
            return false;
        }
        BlockPos updatedPos = clickedBlock != placingBlock ? pos.relative(facing) : pos;
        int posX = updatedPos.getX();
        int posY = updatedPos.getY();
        int posZ = updatedPos.getZ();
        int MAX_PLACEMENT_LENGTH = 65;
        int shiftX = 0;
        int shiftZ = 0;
        boolean shiftY = false;
        int increment = 0;
        switch (player.getDirection()) {
            case NORTH: {
                shiftX = -1;
                shiftZ = -65;
                increment = -1;
                break;
            }
            case SOUTH: {
                shiftX = 1;
                shiftZ = 65;
                increment = 1;
                break;
            }
            case EAST: {
                shiftX = 65;
                shiftZ = 1;
                increment = 1;
                break;
            }
            case WEST: {
                shiftX = -65;
                shiftZ = -1;
                increment = -1;
            }
        }
        boolean haveAnyPlaced = false;
        ItemStack toolItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        for (int x = posX; x != posX + shiftX; x += increment) {
            for (int z = posZ; z != posZ + shiftZ; z += increment) {
                boolean hasPlaced = this.placeBlock(player, level, clickedBlock, pos, new BlockPos(x, posY, z), facing, toolItemStack, placingBlock);
                if (!hasPlaced) {
                    return haveAnyPlaced;
                }
                haveAnyPlaced = true;
            }
        }
        return haveAnyPlaced;
    }

    protected boolean placeBlocksMagnetic(Player player, Level level, BlockPos pos, Direction facing) {
        ItemStack offHandItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        Item item = offHandItemStack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        Block placingBlock = blockItem.getBlock();
        boolean isPlacingBlockCompatible = this.isBlockCompatible(placingBlock.defaultBlockState());
        BlockState clickedBlockState = level.getBlockState(pos);
        Block clickedBlock = clickedBlockState.getBlock();
        if (!isPlacingBlockCompatible) {
            return false;
        }
        BlockPos updatedPos = pos.relative(player.getDirection(), 2);
        int posX = updatedPos.getX();
        int posY = updatedPos.getY();
        int posZ = updatedPos.getZ();
        boolean haveAnyPlaced = false;
        ItemStack toolItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        for (int y = posY + 1; y <= posY + 3; ++y) {
            for (int x = posX - 1; x <= posX + 1; ++x) {
                for (int z = posZ - 1; z <= posZ + 1; ++z) {
                    boolean hasPlaced;
                    BlockPos posToPlace = new BlockPos(x, y, z);
                    if (posToPlace.equals((Object)pos.relative(player.getDirection()).above(2)) || !(hasPlaced = this.placeBlock(player, level, clickedBlock, pos, posToPlace, facing, toolItemStack, placingBlock))) continue;
                    haveAnyPlaced = true;
                }
            }
        }
        return haveAnyPlaced;
    }

    protected boolean placeBlock(Player player, Level level, Block clickedBlock, BlockPos clickedPos, BlockPos pos, Direction facing, ItemStack toolItemStack, Block placingBlock) {
        if (this.hasCriticalDamage(toolItemStack)) {
            return false;
        }
        ItemStack offHandItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        int itemCount = offHandItemStack.getCount();
        if (itemCount < 1) {
            return false;
        }
        if (pos.equals((Object)clickedPos)) {
            return true;
        }
        BlockState blockState = level.getBlockState(pos);
        boolean isReplaceable = this.isBuilderReplaceable(blockState);
        if (!isReplaceable) {
            return false;
        }
        if (placingBlock instanceof FallingBlock && level.isEmptyBlock(pos.below())) {
            return false;
        }
        if (!level.isClientSide()) {
            if (!blockState.isAir()) {
                level.destroyBlock(pos, false);
                if (this.isPlant(level.getBlockState(pos.above()).getBlock())) {
                    level.destroyBlock(pos.above(), false);
                }
            }
            level.setBlock(pos, placingBlock.defaultBlockState(), 11);
            level.updateNeighborsAt(pos, placingBlock);
            this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            if (!player.isCreative()) {
                offHandItemStack.setCount(itemCount - 1);
            }
        }
        SoundEvent soundEvent = placingBlock.defaultBlockState().getSoundType((LevelReader)level, pos, (Entity)player).getPlaceSound();
        this.utils.sound.playSoundByBlock(player, pos, soundEvent);
        return true;
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip, flag)) {
            return;
        }
        for (int i = 0; i <= 9; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1).styledAs(TextStyle.Subheader, i == 4 || i == 2).styledAs(TextStyle.ImportantNotice, i == 6).styledAs(TextStyle.DarkGray, i >= 7 && i <= 8).apply();
            if (i != 6) continue;
            tooltip.addEmptyLine();
        }
    }

    protected boolean isPlant(Block block) {
        return block instanceof VegetationBlock || block instanceof GrowingPlantBlock;
    }

    private boolean isBuilderReplaceable(BlockState blockState) {
        return blockState.is(BlockTags.REPLACEABLE) && !blockState.is(Blocks.LAVA);
    }

    protected boolean isAirOrWater(BlockState blockState) {
        return blockState.isAir() || blockState.is(Blocks.WATER);
    }

    protected boolean isBlockCompatible(BlockState blockState) {
        Block block = blockState.getBlock();
        return !blockState.hasBlockEntity() && (blockState.isSolidRender() || this.utils.blocks.types.isGlassBlock(block));
    }

    @Override
    public boolean isEnhanced() {
        return true;
    }
}

