/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.tools.IModTool;
import com.pekar.angelblock.tools.ModTool;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tooltip.ITooltip;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbility;

public abstract class ModRod
extends ModTool
implements IModTool {
    private final boolean isMagnetic;
    private final ModToolMaterial material;

    public ModRod(ModToolMaterial material, boolean isMagnetic, Item.Properties properties) {
        super(material, material.getIncorrectBlocksForDrops(), 0.0f, -3.0f, properties);
        this.isMagnetic = isMagnetic;
        this.material = material;
    }

    public boolean mineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos pos, LivingEntity entity) {
        if (!this.hasCriticalDamage(itemStack)) {
            this.additionalActionOnMineBlock(itemStack, level, blockState, pos, entity);
        }
        return true;
    }

    protected void additionalActionOnMineBlock(ItemStack itemStack, Level level, BlockState blockState, BlockPos pos, LivingEntity entity) {
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return false;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    @Override
    public boolean isEnhanced() {
        return this.isMagnetic;
    }

    @Override
    public boolean isRod() {
        return true;
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return false;
    }

    @Override
    public ModToolMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void damageOffHandItem(int amount, LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.getItemInHand(InteractionHand.OFF_HAND);
        int durability = itemStack.getMaxDamage() - itemStack.getDamageValue();
        if (durability <= amount) {
            return;
        }
        super.damageOffHandItem(amount, livingEntity);
    }

    protected boolean showExtendedDescription(ITooltip tooltip, TooltipFlag flag) {
        if (!(flag.hasShiftDown() || flag.hasAltDown() || flag.hasControlDown())) {
            tooltip.addLineById("description.rods.press_shift_alt_or_ctrl").apply();
            return false;
        }
        return true;
    }

    protected InteractionResult plant(Player player, Level level, BlockPos pos, InteractionHand hand, Direction facing, Block plantBlock) {
        boolean canSustainPlant = this.utils.blocks.conditions.canSustainPlant(level, pos, plantBlock.defaultBlockState());
        if (!canSustainPlant) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        BlockPos abovePos = pos.above();
        if (facing == Direction.UP && level.getBlockState(abovePos).isAir() && level.getBlockState(abovePos.above()).isAir()) {
            boolean isClientSide = level.isClientSide();
            if (!isClientSide) {
                level.setBlock(abovePos, plantBlock.defaultBlockState(), 11);
                if (plantBlock instanceof DoublePlantBlock) {
                    DoublePlantBlock doublePlant = (DoublePlantBlock)plantBlock;
                    level.setBlock(abovePos.above(), (BlockState)doublePlant.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    level.playSound(null, pos.above(), SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos.above(), itemStack);
                }
            }
            return this.getToolInteractionResult(true, isClientSide);
        }
        return InteractionResult.FAIL;
    }

    @Override
    public int getCriticalDurability() {
        return 1;
    }
}

