/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.armor.Armor;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.GlowingSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.HastePermanentArmorEffect;
import com.pekar.angelblock.events.effect.HealthBoostPermanentArmorEffect;
import com.pekar.angelblock.events.effect.IPermanentArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingArmorEffect;
import com.pekar.angelblock.events.effect.JumpBoostSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.NightVisionSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.SlowFallingSwitchingEffect;
import com.pekar.angelblock.events.effect.SlownessPermanentArmorEffect;
import com.pekar.angelblock.events.effect.StrengthPermanentArmorEffect;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.keybinds.KeyRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class DiamithicArmor
extends Armor {
    private final IPermanentArmorEffect strengthEffect;
    private final IPermanentArmorEffect healthBoostEffect;
    private final IPermanentArmorEffect hasteEffect;
    private final IPermanentArmorEffect slownessEffect;
    private final ISwitchingArmorEffect nightVisionEffect;
    private final ISwitchingArmorEffect jumpBoostEffect;
    private final ISwitchingArmorEffect slowFallingEffect;
    private final ISwitchingArmorEffect glowingEffect;
    private static final int STRENGTH_EFFECT_AMPLIFIER_DEFAULT = 0;
    private static final int STRENGTH_EFFECT_AMPLIFIER_IMPROVED = 1;

    public DiamithicArmor(IPlayer player) {
        super(player);
        this.strengthEffect = new StrengthPermanentArmorEffect(player, this, 0);
        this.nightVisionEffect = (ISwitchingArmorEffect)new NightVisionSwitchingArmorEffect(player, this).availableOnHelmetWithDetector();
        this.healthBoostEffect = new HealthBoostPermanentArmorEffect(player, this, 2);
        this.hasteEffect = new HastePermanentArmorEffect(player, this);
        this.slownessEffect = (IPermanentArmorEffect)new SlownessPermanentArmorEffect(player, this, 0).setupAvailability(this::isSlownessAvailable);
        this.glowingEffect = (ISwitchingArmorEffect)new GlowingSwitchingArmorEffect(player, this).availableOnChestPlateWithSlowFalling();
        this.jumpBoostEffect = new JumpBoostSwitchingArmorEffect(player, this, 2);
        this.slowFallingEffect = (ISwitchingArmorEffect)new SlowFallingSwitchingEffect(player, this).availableOnChestPlateWithSlowFalling();
    }

    @Override
    protected void updateAvailability() {
        this.slownessEffect.updateAvailability();
        this.strengthEffect.updateAvailability();
        this.hasteEffect.updateAvailability();
        this.slowFallingEffect.updateAvailability();
        this.glowingEffect.updateAvailability();
        this.healthBoostEffect.updateAvailability();
        this.jumpBoostEffect.updateAvailability();
        this.nightVisionEffect.updateAvailability();
    }

    @Override
    protected void updateEffectStates() {
        this.nightVisionEffect.updateSwitchState();
        this.jumpBoostEffect.updateSwitchState();
        this.slowFallingEffect.updateSwitchState();
        this.glowingEffect.updateSwitchState();
    }

    @Override
    protected void updateActivity(EquipmentSlot slot) {
        this.slownessEffect.updateActivity();
    }

    @Override
    public void updateActivityForHeadSlot() {
        this.nightVisionEffect.updateActivity();
    }

    @Override
    public void updateActivityForFeetSlot() {
        this.jumpBoostEffect.updateActivity();
    }

    @Override
    public void updateActivityForLegsSlot() {
        this.healthBoostEffect.updateActivity();
    }

    @Override
    public void updateActivityForChestSlot() {
        this.strengthEffect.updateActivity(this.getStrengthEffectAmplifier());
        this.slowFallingEffect.updateActivity();
        this.hasteEffect.updateActivity();
        this.glowingEffect.updateActivity();
    }

    @Override
    protected void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        Player entityPlayer = this.player.getEntity();
        if (this.playerNeedsToRestoreHealth(entityPlayer, event.getSlot(), event.getFrom(), event.getTo())) {
            this.restorePlayerHealth(entityPlayer);
        }
    }

    @Override
    public void onLivingHurtEvent(LivingIncomingDamageEvent event) {
        event.setCanceled(this.player.isFullArmorSetPutOn(this) && this.isLightningBoltDamage(event.getSource()));
    }

    @Override
    public void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        DamageSource damageSource = event.getSource();
        if (this.isExplosionDamage(damageSource)) {
            if (this.player.isChestPlateModifiedWithStrengthBooster(this)) {
                event.setNewDamage(event.getNewDamage() * 0.5f);
            }
        } else if (this.isBiting(damageSource.getEntity())) {
            event.setNewDamage(event.getNewDamage() * 2.0f);
        }
    }

    @Override
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        this.slownessEffect.updateAvailability();
        this.slownessEffect.updateActivity();
    }

    @Override
    public void onLivingFallEvent(LivingFallEvent event) {
        ServerPlayer playerEntity;
        this.slownessEffect.updateAvailability();
        this.slownessEffect.updateActivity();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && !(playerEntity = (ServerPlayer)livingEntity).hasEffect(MobEffects.SLOW_FALLING)) {
            this.breakBlockUnderPlayer(playerEntity, false, this.isIcePredicate, Blocks.WATER.defaultBlockState(), this.playIceBreakSound, 0);
            this.breakBlockUnderPlayer(playerEntity, false, this.isCrackedBlockPredicate, Blocks.AIR.defaultBlockState(), this.playCrackedBlockBreakSound, 0);
            this.breakBlockUnderPlayer(playerEntity, true, this.isNetherrackPredicate, Blocks.AIR.defaultBlockState(), this.playCrackedBlockBreakSound, 20);
        }
    }

    @Override
    public void onCreeperCheck() {
        this.slownessEffect.updateAvailability();
        this.slownessEffect.updateActivity();
        boolean isHelmetModifiedWithDetector = this.player.isHelmetModifiedWithDetector(this);
        this.detectCreepers(isHelmetModifiedWithDetector, false);
        Player player = this.player.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)player;
            this.breakBlockUnderPlayer(playerEntity, true, this.isIcePredicate, Blocks.WATER.defaultBlockState(), this.playIceBreakSound, 32);
            this.breakBlockUnderPlayer(playerEntity, true, this.isCrackedBlockPredicate, Blocks.AIR.defaultBlockState(), this.playCrackedBlockBreakSound, 32);
        }
    }

    @Override
    public void onEffectAddedEvent(MobEffectEvent.Added event) {
    }

    @Override
    public void onKeyInputEvent(String pressedKeyDescription) {
        if (pressedKeyDescription.equals(KeyRegistry.NIGHT_VISION.getName())) {
            this.nightVisionEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.JUMP_BOOST.getName())) {
            this.jumpBoostEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.LEVITATION.getName())) {
            this.slowFallingEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.GLOWING.getName())) {
            this.glowingEffect.trySwitch();
        }
    }

    @Override
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
    }

    @Override
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
    }

    @Override
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (this.jumpBoostEffect.isOn()) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.2f);
        }
    }

    @Override
    public void onBeingInLava() {
    }

    @Override
    public void onBeingInWater() {
        this.slownessEffect.updateAvailability();
        this.slownessEffect.updateActivity();
    }

    @Override
    public void onBeingUnderRain() {
    }

    @Override
    public String getFamilyName() {
        return ((ModArmor)ArmorRegistry.DIAMITHIC_BOOTS.get()).getArmorFamilyName();
    }

    @Override
    public int getPriority() {
        return 3;
    }

    private int getStrengthEffectAmplifier() {
        return this.player.isChestPlateModifiedWithStrengthBooster(this) ? 1 : 0;
    }

    private boolean isSlownessAvailable(IPlayer player, IArmor armor) {
        return player.isAnyArmorElementInclBrokenPutOn(armor) && !player.getEntity().isInWater();
    }
}

