/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.mixins;

import com.pekar.angelblock.Main;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.common.damagesource.IReductionFunction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DamageContainer.class})
public class DamageContainerMixin {
    @Inject(method={"setReduction"}, at={@At(value="HEAD")})
    private void logReduction(DamageContainer.Reduction reduction, float amount, CallbackInfo ci) {
        Main.LOGGER.error("DAMAGE REDUCTION - Type: " + String.valueOf(reduction) + " | Amount: " + amount);
    }

    @Inject(method={"setNewDamage"}, at={@At(value="HEAD")})
    private void logSetNewDamage(float damage, CallbackInfo ci) {
        Main.LOGGER.error("SET NEW DAMAGE: " + damage);
    }

    @Inject(method={"modifyReduction"}, at={@At(value="HEAD")})
    private void logModifyReduction(DamageContainer.Reduction type, float reduction, CallbackInfoReturnable<Float> cir) {
        try {
            Field field = DamageContainer.class.getDeclaredField("reductionFunctions");
            field.setAccessible(true);
            Map reductionFuncs = (Map)field.get(this);
            Main.LOGGER.error("REDUCTION FUNCTIONS - Type: " + String.valueOf(type) + " | Functions: " + String.valueOf(reductionFuncs.getOrDefault(type, List.of())));
            Main.LOGGER.error("MODIFY REDUCTION - Type: " + String.valueOf(type) + " | Before: " + reduction);
            float modified = reduction;
            for (IReductionFunction func : reductionFuncs.getOrDefault(type, List.of())) {
                modified = func.modify((DamageContainer)this, modified);
                Main.LOGGER.error("REDUCTION FUNC: " + func.getClass().getName() + " | New Value: " + modified);
            }
            Main.LOGGER.error("MODIFY REDUCTION - After: " + modified);
        }
        catch (Exception e) {
            Main.LOGGER.error("ERROR ACCESSING reductionFunctions", (Throwable)e);
        }
    }
}

