/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.scheduler;

import com.pekar.angelblock.events.scheduler.IScheduledTask;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;

public abstract class ScheduledTask<T>
implements IScheduledTask<T> {
    private final T object;
    private final BiConsumer<ServerPlayer, T> work;
    private final ServerPlayer player;
    private int counter;
    private boolean isCompleted;

    public ScheduledTask(ServerPlayer player, int ticks, T object, BiConsumer<ServerPlayer, T> work) {
        this.player = player;
        this.counter = ticks;
        this.object = object;
        this.work = work;
    }

    @Override
    public final void decrementOrExecute() {
        if (--this.counter <= 0) {
            this.execute();
        }
    }

    @Override
    public final void execute() {
        if (!this.isCompleted()) {
            this.work.accept(this.player, (ServerPlayer)this.object);
            this.isCompleted = true;
        }
    }

    @Override
    public final boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public final boolean belongsTo(ServerPlayer player) {
        return this.player.getUUID().equals(player.getUUID());
    }
}

