/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.tools.EnhancedHoe;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.properties.IMaterialProperties;
import com.pekar.angelblock.tools.properties.LapisHoeProperties;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.TextStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LapisHoe
extends EnhancedHoe {
    public LapisHoe(ModToolMaterial material, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties, (IMaterialProperties)new LapisHoeProperties());
    }

    @Override
    protected boolean onBlockProcessing(Player player, Level level, BlockPos originalPos, BlockPos pos, Direction facing) {
        if (!level.isEmptyBlock(pos.above())) {
            return false;
        }
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (this.utils.blocks.types.canBeFarmland(block)) {
            if (!level.isClientSide()) {
                level.setBlock(pos, Blocks.FARMLAND.defaultBlockState(), 11);
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            }
            this.utils.sound.playSoundByBlock(player, pos, SoundEvents.HOE_TILL);
            return true;
        }
        if (block == Blocks.COARSE_DIRT) {
            if (!level.isClientSide()) {
                this.setBlock(player, pos, Blocks.DIRT);
                this.damageMainHandItemIfSurvivalIgnoreClient(player, level);
            }
            this.utils.sound.playSoundByBlock(player, pos, SoundEvents.HOE_TILL);
            return true;
        }
        return this.changePodzolToDirt(player, level, pos);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 16; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1 || i == 5 || i == 9).styledAs(TextStyle.Notice, i == 3).styledAs(TextStyle.DarkGray, i == 15).apply();
        }
    }
}

