/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.utils;

import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.utils.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AttributeModifiers {
    public void updateArmorAttributeModifier(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        AttributeInstance armorAttribute = entity.getAttribute(Attributes.ARMOR);
        if (armorAttribute != null) {
            double correctionSum = 0.0;
            for (ItemStack stack : Utils.instance.player.getArmorInSlots(entity)) {
                double damage;
                if (stack.isEmpty()) continue;
                boolean isModArmor = stack.getItem() instanceof ModArmor;
                double maxDamage = stack.getMaxDamage();
                if (maxDamage <= 0.0) continue;
                double d = damage = isModArmor ? (double)stack.getDamageValue() : 0.0;
                Item item = stack.getItem();
                if (!(item instanceof ModArmor)) continue;
                ModArmor modArmor = (ModArmor)item;
                double defense = ((Integer)modArmor.getArmorMaterial().getMaterial().defense().get(modArmor.getArmorType())).intValue();
                double durability = maxDamage - damage;
                double durabilityPercent = durability / maxDamage;
                double correction = defense * (durabilityPercent - 1.0);
                correctionSum += correction;
            }
            ResourceLocation armorModifierId = ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)this.getArmorAttributeMofifierId(entity));
            armorAttribute.removeModifier(armorModifierId);
            if (Math.abs(correctionSum) > 1.0E-12) {
                armorAttribute.addTransientModifier(new AttributeModifier(armorModifierId, correctionSum, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    public void removeArmorAttributeModifier(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        AttributeInstance armorAttribute = entity.getAttribute(Attributes.ARMOR);
        if (armorAttribute != null) {
            ResourceLocation armorModifierId = ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)this.getArmorAttributeMofifierId(entity));
            armorAttribute.removeModifier(armorModifierId);
        }
    }

    private String getArmorAttributeMofifierId(LivingEntity entity) {
        return entity.getStringUUID();
    }
}

