/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.items;

import com.pekar.angelblock.items.ModItem;
import com.pekar.angelblock.potions.BlockBreakerPotion;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.ITooltipProvider;
import com.pekar.angelblock.tooltip.TextStyle;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class BlockBreakerPotionItem
extends ModItem
implements ProjectileItem,
ITooltipProvider {
    public static float PROJECTILE_SHOOT_POWER = 1.0f;

    public BlockBreakerPotionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Projectile.spawnProjectileFromRotation(BlockBreakerPotion::new, (ServerLevel)serverLevel, (ItemStack)itemStack, (LivingEntity)player, (float)0.0f, (float)PROJECTILE_SHOOT_POWER, (float)1.0f);
        }
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return this.sidedSuccess(level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> component, TooltipFlag flag) {
        ITooltipProvider.appendHoverText(this, stack, context, display, component, flag);
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        return new BlockBreakerPotion(position.x(), position.y(), position.z(), level, itemStack);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        for (int i = 0; i <= 20; ++i) {
            tooltip.addLine(this.getDescriptionId(), i).styledAs(TextStyle.Header, i == 1 || i == 12).styledAs(TextStyle.DarkGray, i == 20).apply();
        }
    }
}

