/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.items;

import com.pekar.angelblock.items.ModItem;
import com.pekar.angelblock.mixins.AxolotlAccessor;
import com.pekar.angelblock.tooltip.ITooltip;
import com.pekar.angelblock.tooltip.ITooltipProvider;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class BlueAxolotlBucket
extends ModItem
implements ITooltipProvider {
    public BlueAxolotlBucket(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Axolotl axolotl = (Axolotl)EntityType.AXOLOTL.create((Level)serverLevel, EntitySpawnReason.BUCKET);
                if (axolotl != null) {
                    axolotl.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                    ((AxolotlAccessor)axolotl).invokeSetVariant(Axolotl.Variant.BLUE);
                    axolotl.setBaby(true);
                    axolotl.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(new BlockPos((Vec3i)pos)), EntitySpawnReason.BUCKET, null);
                    boolean result = serverLevel.addFreshEntity((Entity)axolotl);
                    if (result) {
                        level.playSound(null, pos, SoundEvents.BUCKET_EMPTY_AXOLOTL, SoundSource.BLOCKS);
                        level.setBlock(pos, Blocks.WATER.defaultBlockState(), 11);
                        player.setItemInHand(context.getHand(), new ItemStack((ItemLike)Items.BUCKET));
                    }
                }
            }
        }
        return this.sidedSuccess(level.isClientSide());
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public int getDefaultMaxStackSize() {
        return 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> component, TooltipFlag flag) {
        ITooltipProvider.appendHoverText(this, stack, context, display, component, flag);
    }

    @Override
    public void addTooltip(ItemStack stack, Item.TooltipContext context, ITooltip tooltip, TooltipFlag flag) {
        if (!this.utils.text.showExtendedDescription(tooltip)) {
            return;
        }
        tooltip.addLine(this.getDescriptionId()).asNotice().apply();
    }
}

