/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;

public class PlayerConditions {
    PlayerConditions() {
    }

    public boolean isFallSafeWide(LivingEntity entityPlayer, BlockPos pos) {
        BlockPos playerPos = entityPlayer.blockPosition();
        if (playerPos.getY() > pos.getY()) {
            return Math.abs(playerPos.getX() - pos.getX()) >= 2 || Math.abs(playerPos.getZ() - pos.getZ()) >= 2 || !this.isAboveLavaOrWaterOrAir(entityPlayer.level(), pos);
        }
        return !this.isStandingUnderFallingBlock(entityPlayer, pos);
    }

    public boolean isFallSafeExact(LivingEntity entityPlayer, BlockPos pos) {
        if (!this.isAboveBreakingBlock(entityPlayer, pos)) {
            return true;
        }
        return !this.isAboveLavaOrWaterOrAir(entityPlayer.level(), pos);
    }

    public boolean isStandingOnBreakingBlock(LivingEntity entityPlayer, BlockPos pos) {
        BlockPos playerPos = entityPlayer.blockPosition();
        return playerPos.getX() == pos.getX() && playerPos.getZ() == pos.getZ() && playerPos.getY() == pos.getY() + 1;
    }

    public boolean isAboveBreakingBlock(LivingEntity entityPlayer, BlockPos pos) {
        BlockPos playerPos = entityPlayer.blockPosition();
        return playerPos.getX() == pos.getX() && playerPos.getZ() == pos.getZ() && playerPos.getY() > pos.getY();
    }

    public boolean isStandingUnderFallingBlock(LivingEntity entity, BlockPos pos) {
        BlockPos entityPos = entity.blockPosition();
        if (Math.abs(entityPos.getX() - pos.getX()) > 1 || Math.abs(entityPos.getZ() - pos.getZ()) > 1 || entityPos.getY() >= pos.getY()) {
            return false;
        }
        Block blockAboveBreaking = entity.level().getBlockState(pos.above()).getBlock();
        return blockAboveBreaking instanceof FallingBlock;
    }

    public boolean isNearLavaOrWaterOrUnsafe(LivingEntity entityPlayer, BlockPos pos) {
        return this.isNearLavaOrWater(entityPlayer, pos) || !this.isFallSafeWide(entityPlayer, pos);
    }

    public boolean isNearLavaOrWaterOrUnsafeOrStandingOnBreakingBlock(LivingEntity entityPlayer, BlockPos pos) {
        return this.isNearLavaOrWater(entityPlayer, pos) || !this.isFallSafeWide(entityPlayer, pos) || this.isStandingOnBreakingBlock(entityPlayer, pos);
    }

    private boolean isAboveLavaOrWaterOrAir(Level level, BlockPos pos) {
        return level.isEmptyBlock(pos.below()) || level.getBlockState(pos.below()).getBlock() instanceof LiquidBlock;
    }

    public boolean isNearLavaOrWater(LivingEntity entityPlayer, BlockPos pos) {
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        Level level = entityPlayer.level();
        for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int y = posY; y <= posY + 1; ++y) {
                if (x != posX && y != posY) continue;
                for (int z = posZ - 1; z <= posZ + 1; ++z) {
                    Block block;
                    if (z != posZ && (x != posX || y != posY) || ((block = level.getBlockState(new BlockPos(x, y, z)).getBlock()) != Blocks.LAVA || entityPlayer.isInLava()) && (block != Blocks.WATER || entityPlayer.isInWater())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isNearMushroomOrMycelium(Level level, BlockPos pos) {
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        int threshold = 5;
        for (int x = posX - 5; x <= posX + 5; ++x) {
            for (int y = posY - 5; y <= posY + 5; ++y) {
                for (int z = posZ - 5; z <= posZ + 5; ++z) {
                    Block block = level.getBlockState(new BlockPos(x, y, z)).getBlock();
                    if (block != Blocks.RED_MUSHROOM && block != Blocks.BROWN_MUSHROOM && block != Blocks.RED_MUSHROOM_BLOCK && block != Blocks.BROWN_MUSHROOM_BLOCK && block != Blocks.MYCELIUM && block != Blocks.MOSSY_COBBLESTONE) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

