/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events;

import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.IEventHandler;
import com.pekar.angelblock.events.IPlayerManager;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.armor.IArmorEvents;
import com.pekar.angelblock.events.cleaners.Cleaner;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.events.player.Player;
import com.pekar.angelblock.events.scheduler.PlayerScheduler;
import com.pekar.angelblock.events.scheduler.allay.RestoreAllaysTask;
import com.pekar.angelblock.items.ItemRegistry;
import com.pekar.angelblock.network.packets.PlaySoundPacket;
import com.pekar.angelblock.network.packets.UpdateArmorDurabilityPacketToClient;
import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.utils.Utils;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerManager
implements IEventHandler,
IPlayerManager {
    private final Map<UUID, IPlayer> players = new ConcurrentHashMap<UUID, IPlayer>();
    private static final IPlayerManager instance = new PlayerManager();

    public static IPlayerManager instance() {
        return instance;
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        net.minecraft.world.entity.player.Player entity = event.getEntity();
        PlayerScheduler.add(new RestoreAllaysTask((ServerPlayer)entity, 20));
        Player player = new Player(entity);
        this.players.put(player.getEntity().getUUID(), player);
        player.updateArmorUsed();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            new UpdateArmorDurabilityPacketToClient().sendToPlayer(serverPlayer);
        }
        for (IArmorEvents iArmorEvents : player.getArmorTypesUsed()) {
            iArmorEvents.onPlayerLoggedInEvent(event);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Cleaner.clean((net.minecraft.world.entity.player.Player)player);
        PlayerScheduler.cancelAll(player);
        this.players.remove(event.getEntity().getUUID());
    }

    @SubscribeEvent
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        IPlayer player = this.players.get(entity.getUUID());
        if (player == null) {
            return;
        }
        net.minecraft.world.entity.player.Player playerEntity = player.getEntity();
        Cleaner.clean(playerEntity);
        for (IArmorEvents iArmorEvents : player.getArmorTypesUsed()) {
            iArmorEvents.onEntityTravelToDimensionEvent(event);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        net.minecraft.world.entity.player.Player entity = event.getEntity();
        PlayerScheduler.add(new RestoreAllaysTask((ServerPlayer)entity, 20));
        IPlayer player = this.players.get(entity.getUUID());
        if (player == null) {
            return;
        }
        for (IArmorEvents iArmorEvents : player.getArmorTypesUsed()) {
            iArmorEvents.onPlayerChangedDimensionEvent(event);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        net.minecraft.world.entity.player.Player entity = event.getEntity();
        if (entity.level().isClientSide()) {
            return;
        }
        PlayerScheduler.add(new RestoreAllaysTask((ServerPlayer)entity, 20));
        IPlayer player = this.players.get(entity.getUUID());
        if (player == null) {
            return;
        }
        player.updateEntity(entity);
    }

    @SubscribeEvent
    public void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        EquipmentSlot slot;
        IPlayer player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            new UpdateArmorDurabilityPacketToClient().sendToPlayer(serverPlayer);
        }
        if ((player = this.players.get(entity.getUUID())) == null) {
            return;
        }
        net.minecraft.world.entity.player.Player playerEntity = player.getEntity();
        ItemStack oldSlotItem = event.getFrom();
        ItemStack offHandItemStack = playerEntity.getOffhandItem();
        this.removeEffectIfHoldItem(playerEntity, (Holder<MobEffect>)MobEffects.NIGHT_VISION, oldSlotItem, offHandItemStack, (Item)ItemRegistry.GUARDIAN_EYE.get());
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (event.getTo().is(ItemRegistry.ENERGY_CRYSTAL)) {
                if (!(entity.hasEffect(MobEffects.MOVEMENT_SPEED) || entity.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) || entity.hasEffect(PotionRegistry.ARMOR_HEAVY_JUMP_EFFECT))) {
                    player.setCrystalEffect((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, -1, 3, true);
                    new PlaySoundPacket((SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), 2.0f).sendToPlayer(serverPlayer);
                }
            } else if (oldSlotItem.is(ItemRegistry.ENERGY_CRYSTAL) && !entity.getMainHandItem().is(ItemRegistry.ENERGY_CRYSTAL) && !entity.getOffhandItem().is(ItemRegistry.ENERGY_CRYSTAL) && entity.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                player.clearEffect((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED);
                new PlaySoundPacket(SoundEvents.LEVER_CLICK, 2.0f).sendToPlayer(serverPlayer);
            }
        }
        if ((slot = event.getSlot()).isArmor() || slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            Iterable<IArmor> armorUsed = player.getArmorTypesUsed();
            HashSet armorAffected = new HashSet((Collection)armorUsed);
            player.updateArmorUsed();
            armorAffected.addAll((Collection)player.getArmorTypesUsed());
            if (armorAffected.isEmpty()) {
                Utils.instance.attributeModifiers.removeArmorAttributeModifier((LivingEntity)playerEntity);
            }
            ToIntFunction<IArmor> armorPriority = PlayerManager.getArmorPriorityFunction(event);
            for (IArmor armor : armorAffected.stream().sorted(Comparator.comparingInt(armorPriority)).toList()) {
                armor.onLivingEquipmentChangeEvent(event);
            }
        }
    }

    @NotNull
    private static ToIntFunction<IArmor> getArmorPriorityFunction(LivingEquipmentChangeEvent event) {
        String toItemName;
        String fromItemName;
        ModArmor modArmor;
        ItemStack from = event.getFrom();
        ItemStack to = event.getTo();
        Item item = from.getItem();
        if (item instanceof ModArmor) {
            modArmor = (ModArmor)item;
            fromItemName = modArmor.getArmorFamilyName();
        } else {
            fromItemName = "";
        }
        item = to.getItem();
        if (item instanceof ModArmor) {
            modArmor = (ModArmor)item;
            toItemName = modArmor.getArmorFamilyName();
        } else {
            toItemName = "";
        }
        ToIntFunction<IArmor> armorPriority = a -> {
            if (a.getFamilyName().equals(fromItemName)) {
                return 0;
            }
            if (a.getFamilyName().equals(toItemName)) {
                return 100;
            }
            return a.getPriority() + 2;
        };
        return armorPriority;
    }

    @Override
    public IPlayer getPlayerByUUID(UUID uuid) {
        return this.players.values().stream().filter(p -> p.getEntity().getUUID().equals(uuid)).findAny().orElse(null);
    }

    @Override
    public void addEntityPlayer(net.minecraft.world.entity.player.Player entity) {
        Player player = new Player(entity);
        this.players.put(player.getEntity().getUUID(), player);
        player.updateArmorUsed();
    }

    @Override
    public void sendMessage(String message) {
        for (IPlayer player : this.players.values()) {
            player.sendMessage(message);
        }
    }

    private void removeEffectIfHoldItem(net.minecraft.world.entity.player.Player player, Holder<MobEffect> effect, ItemStack slotItemStack, ItemStack offHandItemStack, Item holdItemToCheck) {
        ServerPlayer serverPlayer;
        block5: {
            block4: {
                if (!(player instanceof ServerPlayer)) break block4;
                serverPlayer = (ServerPlayer)player;
                if (player.hasEffect(effect)) break block5;
            }
            return;
        }
        if (!slotItemStack.isEmpty() && slotItemStack.getItem() == holdItemToCheck || !offHandItemStack.isEmpty() && offHandItemStack.getItem() == holdItemToCheck) {
            player.removeEffect(effect);
            new PlaySoundPacket(SoundEvents.LEVER_CLICK, 2.0f).sendToPlayer(serverPlayer);
        }
    }
}

