/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.events.armor.Armor;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.effect.ISwitchingArmorEffect;
import com.pekar.angelblock.events.effect.ISwitchingEffectSynchronizer;
import com.pekar.angelblock.events.effect.JumpBoostSwitchingArmorEffect;
import com.pekar.angelblock.events.effect.SlowFallingSwitchingEffect;
import com.pekar.angelblock.events.effect.SpeedSwitchingEffect;
import com.pekar.angelblock.events.effect.SuperJumpSwitchingEffect;
import com.pekar.angelblock.events.effect.SwitchingEffectSynchronizer;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.keybinds.KeyRegistry;
import com.pekar.angelblock.utils.Utils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class FlyingArmor
extends Armor {
    private final ISwitchingEffectSynchronizer jumpBoostEffect;
    private final ISwitchingArmorEffect slowFallingEffect;
    private static final int JUMP_BOOST_AMPLIFIER = 24;
    private boolean isSlowFallingActivatedOnGround = true;

    public FlyingArmor(IPlayer player) {
        super(player);
        this.slowFallingEffect = (ISwitchingArmorEffect)new SlowFallingSwitchingEffect(player, this).availableIfSlotSet(EquipmentSlot.CHEST);
        SpeedSwitchingEffect speedEffect = new SpeedSwitchingEffect(player, this, 1);
        speedEffect.setupAvailability(this::isJumpEffectAvailable);
        JumpBoostSwitchingArmorEffect jumpBoostEffect = new JumpBoostSwitchingArmorEffect(player, this, 24);
        jumpBoostEffect.setupAvailability(this::isJumpEffectAvailable);
        SuperJumpSwitchingEffect superJumpEffect = new SuperJumpSwitchingEffect(player, this);
        superJumpEffect.setupAvailability(this::isJumpEffectAvailable);
        this.jumpBoostEffect = new SwitchingEffectSynchronizer(jumpBoostEffect);
        this.jumpBoostEffect.addDependentEffect(speedEffect);
        this.jumpBoostEffect.addDependentEffect(superJumpEffect);
    }

    @Override
    protected void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.isSlowFallingActivatedOnGround = this.player.getEntity().onGround();
    }

    @Override
    protected void updateAvailability() {
        this.jumpBoostEffect.updateAvailability();
        this.slowFallingEffect.updateAvailability();
    }

    @Override
    protected void updateEffectStates() {
        this.jumpBoostEffect.updateSwitchState();
        if (!this.player.isNether()) {
            this.slowFallingEffect.updateSwitchState();
        }
    }

    @Override
    protected void updateActivityForHeadSlot() {
    }

    @Override
    protected void updateActivityForFeetSlot() {
    }

    @Override
    protected void updateActivityForLegsSlot() {
    }

    @Override
    protected void updateActivityForChestSlot() {
        this.slowFallingEffect.updateActivity();
    }

    @Override
    protected void updateActivity(EquipmentSlot slot) {
        this.jumpBoostEffect.updateActivity();
    }

    @Override
    protected void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        this.slowFallingEffect.updateSwitchState();
        if (event.getTo().is(Items.FIREWORK_ROCKET)) {
            this.player.getEntity().stopFallFlying();
        }
    }

    @Override
    public String getFamilyName() {
        return ((ModArmor)ArmorRegistry.FLYING_BOOTS.get()).getArmorFamilyName();
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void onLivingHurtEvent(LivingIncomingDamageEvent event) {
        if (this.isFreezeDamage(event.getSource())) {
            boolean areBootsWorn = this.player.isArmorElementPutOn(this, EquipmentSlot.FEET);
            event.setCanceled(areBootsWorn);
        }
    }

    @Override
    public void onLivingDamageEvent(LivingDamageEvent.Pre event) {
    }

    @Override
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        this.updateSlowFallingEffect();
    }

    @Override
    public void onLivingFallEvent(LivingFallEvent event) {
        if (this.player.isArmorElementPutOn(this, EquipmentSlot.FEET)) {
            event.setDamageMultiplier(0.1f);
        }
    }

    @Override
    public void onKeyInputEvent(String pressedKeyDescription) {
        if (pressedKeyDescription.equals(KeyRegistry.JUMP_BOOST.getName()) || pressedKeyDescription.equals(KeyRegistry.SUPER_JUMP.getName())) {
            this.jumpBoostEffect.trySwitch();
        }
        if (pressedKeyDescription.equals(KeyRegistry.LEVITATION.getName())) {
            this.slowFallingEffect.trySwitch();
            this.isSlowFallingActivatedOnGround = this.slowFallingEffect.isOn() ? this.player.getEntity().onGround() : true;
            if (this.slowFallingEffect.isActive()) {
                this.player.getEntity().stopFallFlying();
            }
        }
    }

    @Override
    public void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
    }

    @Override
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.jumpBoostEffect.updateAvailability();
        this.slowFallingEffect.updateAvailability();
        this.jumpBoostEffect.updateActivity();
        this.slowFallingEffect.updateActivity();
    }

    @Override
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (this.player.getEntity().isInWaterRainOrBubble() || this.jumpBoostEffect.isOn()) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.2f);
        }
    }

    @Override
    public void onBeingInLava() {
        if (this.slowFallingEffect.isOn()) {
            this.slowFallingEffect.trySwitchOff();
        }
    }

    @Override
    public void onBeingInWater() {
        if (this.slowFallingEffect.isOn()) {
            this.slowFallingEffect.trySwitchOff();
        }
    }

    @Override
    public void onBeingUnderRain() {
    }

    @Override
    public void onCreeperCheck() {
        this.updateSlowFallingEffect();
        Player playerEntity = this.player.getEntity();
        if (playerEntity.isFallFlying() && this.player.isArmorElementPutOn(this, EquipmentSlot.CHEST) && !this.canFly()) {
            playerEntity.stopFallFlying();
        }
    }

    @Override
    public void onEffectAddedEvent(MobEffectEvent.Added event) {
    }

    private boolean isJumpEffectAvailable(IPlayer player, IArmor armor) {
        ItemStack boots = player.getEntity().getItemBySlot(EquipmentSlot.FEET);
        int bootsDamage = boots.getDamageValue();
        int maxBootsDamageToJump = boots.getMaxDamage() / 2;
        return player.isArmorElementPutOn(this, EquipmentSlot.FEET) && bootsDamage < maxBootsDamageToJump;
    }

    private boolean canFly() {
        if (!this.player.isFullArmorSetPutOn(this)) {
            return false;
        }
        Player playerEntity = this.player.getEntity();
        if (playerEntity.hasEffect(MobEffects.SLOW_FALLING)) {
            return false;
        }
        if (Utils.instance.dimension.isNether((ResourceKey<Level>)playerEntity.level().dimension()) || playerEntity.isInWaterRainOrBubble()) {
            return false;
        }
        ItemStack mainHandItemStack = playerEntity.getMainHandItem();
        if (mainHandItemStack.is(Items.FIREWORK_ROCKET)) {
            return false;
        }
        ItemStack offHandItemStack = playerEntity.getOffhandItem();
        if (offHandItemStack.is(Items.FIREWORK_ROCKET)) {
            return false;
        }
        ItemStack chestplate = playerEntity.getItemBySlot(EquipmentSlot.CHEST);
        int maxDamageToFly = chestplate.getMaxDamage() / 2;
        int chestDamage = chestplate.getDamageValue();
        return chestDamage < maxDamageToFly;
    }

    private void updateSlowFallingEffect() {
        if (!this.isSlowFallingActivatedOnGround && this.slowFallingEffect.isOn() && this.player.getEntity().onGround()) {
            this.slowFallingEffect.trySwitchOff();
            this.isSlowFallingActivatedOnGround = true;
        }
    }
}

