/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events.cleaners;

import com.pekar.angelblock.events.cleaners.TargetBehavior;
import com.pekar.angelblock.events.cleaners.TrackedBlock;
import net.minecraft.core.BlockPos;

class BlockTargetBehavior
extends TargetBehavior<TrackedBlock> {
    private static final double DistanceToDecreaseSqr = 100.0;
    private static final double DistanceToRemoveImmediatelySqr = 3600.0;
    private static final double CloseDistanceToRemoveImmediatelySqr = 4.0;

    public BlockTargetBehavior(TrackedBlock target) {
        super(target);
    }

    @Override
    public boolean shouldDecrement() {
        return this.getDistanceToOwnerSqr() > 100.0;
    }

    @Override
    public boolean shouldReset() {
        return false;
    }

    @Override
    public boolean shouldRemove() {
        if (((TrackedBlock)this.target).getTicksLeft() <= 0) {
            return true;
        }
        double distanceToOwnerSqr = this.getDistanceToOwnerSqr();
        return distanceToOwnerSqr > 3600.0 || ((TrackedBlock)this.target).needToRemoveWhenClosely() && distanceToOwnerSqr <= 4.0;
    }

    @Override
    public boolean shouldUntrack() {
        return false;
    }

    @Override
    public boolean canBeRemovedOnClean() {
        return true;
    }

    @Override
    public void onRemove() {
    }

    @Override
    public void onUnableToRemove() {
    }

    private double getDistanceToOwnerSqr() {
        BlockPos pos = ((TrackedBlock)this.target).getPos();
        return ((TrackedBlock)this.target).getOwner().distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }
}

