/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.potions;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.explosions.ExplosionNoHurtEntityDamageCalculator;
import com.pekar.angelblock.items.ItemRegistry;
import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.utils.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockBreakerPotion
extends ThrowableItemProjectile {
    private final Utils utils = new Utils();
    private final LivingEntity shooter;
    private static final ExplosionDamageCalculator explosionCalculator = new ExplosionNoHurtEntityDamageCalculator();

    public BlockBreakerPotion(EntityType<? extends BlockBreakerPotion> type, Level level) {
        super(type, level);
        this.shooter = null;
    }

    public BlockBreakerPotion(Level level, LivingEntity shooter, ItemStack itemStack) {
        super((EntityType)PotionRegistry.BLOCK_BREAKER_POTION.get(), shooter, level, itemStack);
        this.shooter = shooter;
    }

    public BlockBreakerPotion(double x, double y, double z, Level level, ItemStack item) {
        super((EntityType)PotionRegistry.BLOCK_BREAKER_POTION.get(), x, y, z, level, item);
        this.shooter = null;
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegistry.BLOCK_BREAKER_POTION_ITEM.get();
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (this.shooter == null) {
            return;
        }
        Level level = this.shooter.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 location = result.getLocation();
        BlockPos pos = new BlockPos((int)location.x, (int)location.y, (int)location.z);
        List<LivingEntity> targetEntities = level.getEntities((Entity)null, new AABB(pos).inflate(3.0), e -> e instanceof LivingEntity).stream().map(x -> (LivingEntity)x).toList();
        level.explode((Entity)this, null, explosionCalculator, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.0f, false, Level.ExplosionInteraction.NONE);
        this.applyKnockback(level, location, 1.0f);
        for (LivingEntity target : targetEntities) {
            if (target instanceof Player) continue;
            this.destroyDiamondArmor(serverLevel, target);
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (this.shooter == null) {
            return;
        }
        BlockPos position = result.getBlockPos();
        int X = position.getX();
        int Y = position.getY();
        int Z = position.getZ();
        for (int x = X - 1; x <= X + 1; ++x) {
            for (int y = Y - 1; y <= Y + 1; ++y) {
                for (int z = Z - 1; z <= Z + 1; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    this.applyPotionToBlock((Entity)this.shooter, currentPos);
                }
            }
        }
    }

    private void applyKnockback(Level level, Vec3 explosionPos, float strength) {
        float radius = strength * 2.0f;
        AABB area = new AABB(explosionPos.x - (double)radius, explosionPos.y - (double)radius, explosionPos.z - (double)radius, explosionPos.x + (double)radius, explosionPos.y + (double)radius, explosionPos.z + (double)radius);
        List entities = level.getEntitiesOfClass(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            double distance = entity.position().distanceTo(explosionPos);
            if (distance > (double)radius) continue;
            double dx = entity.getX() - explosionPos.x;
            double dz = entity.getZ() - explosionPos.z;
            double scale = 1.0 - distance / (double)radius;
            double power = (double)strength * scale * 0.5;
            entity.knockback(power, dx, dz);
        }
    }

    private void destroyDiamondArmor(ServerLevel serverLevel, LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack;
            if (!slot.isArmor() || (itemStack = entity.getItemBySlot(slot)).isEmpty() || !itemStack.is(ItemTags.TRIMMABLE_ARMOR) || !itemStack.is(ItemRegistry.DIAMOND_ARMOR_TAG)) continue;
            entity.setItemSlot(slot, ItemStack.EMPTY);
            int itemCount = switch (slot) {
                case EquipmentSlot.CHEST -> 8;
                case EquipmentSlot.HEAD -> 5;
                case EquipmentSlot.FEET -> 4;
                case EquipmentSlot.LEGS -> 7;
                default -> 0;
            };
            int dropsNumber = this.random.nextIntBetweenInclusive(itemCount / 3, itemCount);
            entity.spawnAtLocation(serverLevel, new ItemStack((ItemLike)ItemRegistry.DIAMOND_POWDER.get(), dropsNumber), 1.0f);
        }
    }

    private void applyPotionToBlock(@NotNull Entity source, BlockPos pos) {
        Level level = source.level();
        Block block = level.getBlockState(pos).getBlock();
        if (block == Blocks.DIAMOND_BLOCK) {
            level.setBlock(pos, ((Block)BlockRegistry.DESTROYING_DIAMOND_POWDER_BLOCK.get()).defaultBlockState(), 4);
            level.destroyBlock(pos, true, source, 1);
        } else if (block == Blocks.COBBLESTONE) {
            level.setBlock(pos, Blocks.GRAVEL.defaultBlockState(), 11);
        } else if (block == Blocks.STONE) {
            level.setBlock(pos, Blocks.SAND.defaultBlockState(), 11);
        } else if (block == Blocks.LAVA && level.getFluidState(pos).getAmount() == 8) {
            level.setBlock(pos, Blocks.END_STONE.defaultBlockState(), 11);
        } else if (block == Blocks.WATER && this.utils.blocks.conditions.isUnderAirBlock(level, pos)) {
            level.setBlock(pos, Blocks.ICE.defaultBlockState(), 11);
        } else if (block == Blocks.TUFF) {
            level.setBlock(pos, ((Block)BlockRegistry.DESTROYING_SALTPETER.get()).defaultBlockState(), 4);
            level.destroyBlock(pos, true, source, 1);
        } else if (block == Blocks.GLASS) {
            level.setBlock(pos, ((Block)BlockRegistry.DESTROYING_PRISMARINE_SHARD_BLOCK.get()).defaultBlockState(), 4);
            level.destroyBlock(pos, true, source, 1);
        } else if (block == Blocks.GRANITE) {
            level.setBlock(pos, Blocks.RED_SAND.defaultBlockState(), 11);
        } else if (block == Blocks.GRASS_BLOCK || block == Blocks.FARMLAND) {
            level.setBlock(pos, Blocks.DIRT_PATH.defaultBlockState(), 11);
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 11);
        } else if (block == Blocks.ICE || block == Blocks.SNOW_BLOCK) {
            level.setBlock(pos, Blocks.POWDER_SNOW.defaultBlockState(), 11);
        } else if (block == Blocks.PACKED_ICE || block == Blocks.BLUE_ICE) {
            level.setBlock(pos, Blocks.SNOW.defaultBlockState(), 11);
        } else if (block == Blocks.SAND && this.utils.blocks.conditions.isNearWaterHorizontal(level, pos)) {
            level.setBlock(pos, Blocks.CLAY.defaultBlockState(), 4);
            level.destroyBlock(pos, true, source, 1);
            level.setBlock(pos, Blocks.WATER.defaultBlockState(), 11);
        } else if (block == Blocks.PRISMARINE) {
            level.setBlock(pos, ((Block)BlockRegistry.DESTROYING_PRISMARINE_CRYSTALS.get()).defaultBlockState(), 4);
            level.destroyBlock(pos, true, source, 1);
        } else {
            Block woolBlock = this.utils.blocks.types.getDestroyingWoolBlock(block);
            if (woolBlock != null) {
                level.setBlock(pos, woolBlock.defaultBlockState(), 4);
                level.destroyBlock(pos, true, source, 1);
            }
        }
    }
}

