/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.armor;

import com.pekar.angelblock.armor.ArmorRegistry;
import com.pekar.angelblock.armor.ModArmor;
import com.pekar.angelblock.armor.ModArmorMaterial;
import com.pekar.angelblock.potions.PotionRegistry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorType;
import org.jetbrains.annotations.Nullable;

public class SuperArmor
extends ModArmor {
    protected SuperArmor(ModArmorMaterial material, ArmorType equipmentSlot, Item.Properties properties) {
        super(material, equipmentSlot, properties);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        ItemStack itemStack = wearer.getItemBySlot(EquipmentSlot.LEGS);
        Item leggingsItem = itemStack.getItem();
        if (!(leggingsItem instanceof ModArmor)) {
            return false;
        }
        ModArmor leggings = (ModArmor)leggingsItem;
        return leggings.getArmorFamilyName().equals(((ModArmor)ArmorRegistry.SUPER_LEGGINGS.get()).getArmorFamilyName());
    }

    public boolean isGazeDisguise(ItemStack stack, Player player, @Nullable LivingEntity entity) {
        ItemStack itemStack = player.getItemBySlot(EquipmentSlot.HEAD);
        Item helmetItem = itemStack.getItem();
        if (!(helmetItem instanceof ModArmor)) {
            return false;
        }
        ModArmor helmet = (ModArmor)helmetItem;
        return helmet.getArmorFamilyName().equals(((ModArmor)ArmorRegistry.SUPER_HELMET.get()).getArmorFamilyName());
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        ItemStack itemStack = wearer.getItemBySlot(EquipmentSlot.FEET);
        Item bootsItem = itemStack.getItem();
        if (!(bootsItem instanceof ModArmor)) {
            return false;
        }
        ModArmor boots = (ModArmor)bootsItem;
        return boots.getArmorFamilyName().equals(((ModArmor)ArmorRegistry.SUPER_BOOTS.get()).getArmorFamilyName()) && !wearer.hasEffect(PotionRegistry.ARMOR_HEAVY_JUMP_EFFECT);
    }
}

