/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.events;

import com.pekar.angelblock.events.IEventHandler;
import com.pekar.angelblock.events.ILivingDeathEventHandler;
import com.pekar.angelblock.events.IPlayerManager;
import com.pekar.angelblock.events.PlayerManager;
import com.pekar.angelblock.events.armor.IArmor;
import com.pekar.angelblock.events.cleaners.Cleaner;
import com.pekar.angelblock.events.player.IPlayer;
import com.pekar.angelblock.events.scheduler.PlayerScheduler;
import com.pekar.angelblock.events.scheduler.allay.RestoreAllaysTask;
import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.IModTool;
import com.pekar.angelblock.tools.IModToolEnhanceable;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class PlayerInteractionEvents
implements IEventHandler {
    private final IPlayerManager playerBasic = PlayerManager.instance();
    private static final Map<BlockPos, ILivingDeathEventHandler> livingDeathEventListeners = new ConcurrentHashMap<BlockPos, ILivingDeathEventHandler>();

    @SubscribeEvent
    public void onLivingHurtEvent(LivingIncomingDamageEvent event) {
        IModTool modTool;
        Item item;
        ItemStack weapon;
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity attacker = damageSource.getEntity();
        if (attacker != null && (damageSource.is(DamageTypes.PLAYER_ATTACK) || damageSource.is(DamageTypes.MOB_ATTACK)) && (weapon = attacker.getWeaponItem()) != null && (item = weapon.getItem()) instanceof IModTool && (modTool = (IModTool)item).hasCriticalDamage(weapon)) {
            event.setCanceled(true);
            return;
        }
        IPlayer player = this.playerBasic.getPlayerByUUID(entity.getUUID());
        if (player == null) {
            return;
        }
        for (IArmor armor : player.getArmorTypesUsed()) {
            armor.onLivingHurtEvent(event);
        }
    }

    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent.Pre event) {
        IPlayer player;
        Item item;
        ItemStack weapon;
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity attacker = damageSource.getEntity();
        if (attacker != null && (damageSource.is(DamageTypes.PLAYER_ATTACK) || damageSource.is(DamageTypes.MOB_ATTACK)) && (weapon = attacker.getWeaponItem()) != null && (item = weapon.getItem()) instanceof IModTool) {
            IModTool modTool = (IModTool)item;
            if (modTool.hasExtraLowEfficiencyDamage(weapon)) {
                event.setNewDamage(event.getNewDamage() * 0.4f);
            } else if (modTool.hasLowEfficiencyDamage(weapon)) {
                event.setNewDamage(event.getNewDamage() * 0.6f);
            }
        }
        if ((player = this.playerBasic.getPlayerByUUID(entity.getUUID())) == null) {
            return;
        }
        for (IArmor armor : player.getArmorTypesUsed()) {
            armor.onLivingDamageEvent(event);
        }
    }

    @SubscribeEvent
    public void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        IPlayer player = this.playerBasic.getPlayerByUUID(entity.getUUID());
        if (player == null) {
            return;
        }
        for (IArmor armor : player.getArmorTypesUsed()) {
            armor.onEffectAddedEvent(event);
        }
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        IPlayer player = this.playerBasic.getPlayerByUUID(event.getEntity().getUUID());
        if (player == null) {
            return;
        }
        for (IArmor armor : player.getArmorTypesUsed()) {
            armor.onLivingJumpEvent(event);
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        IPlayer player = this.playerBasic.getPlayerByUUID(event.getEntity().getUUID());
        if (player == null) {
            return;
        }
        for (IArmor armor : player.getArmorTypesUsed()) {
            armor.onLivingFallEvent(event);
        }
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        Item item;
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        ItemStack tool = player.getMainHandItem();
        if (!tool.isEmpty() && (item = tool.getItem()) instanceof IModToolEnhanceable) {
            IModToolEnhanceable modTool = (IModToolEnhanceable)item;
            if (modTool.hasCriticalDamage(tool) && player.hasEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT)) {
                player.removeEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT);
            }
            event.setCanceled(modTool.preventBlockBreak(player, tool, pos));
        }
    }

    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Cleaner.clean(player);
            }
            for (ILivingDeathEventHandler handler : livingDeathEventListeners.values()) {
                handler.onLivingDeathEvent(event);
            }
            if (entity.hasEffect(MobEffects.LUCK) && !event.isCanceled() && !event.getSource().is(DamageTypes.GENERIC_KILL)) {
                int luckLevel = entity.getEffect(MobEffects.LUCK).getAmplifier() + 1;
                float chanceToAvoidDeath = 0.25f * (float)luckLevel;
                if (entity.getRandom().nextFloat() < chanceToAvoidDeath) {
                    event.setCanceled(true);
                    entity.setHealth(1.0f);
                    this.teleportPlayer(entity);
                }
            }
        }
    }

    private void teleportPlayer(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            TeleportTransition.PostTeleportTransition postTeleportTransition = p -> {
                if (p instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)p;
                    this.protectPlayer(livingEntity);
                }
                if (p instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)p;
                    PlayerScheduler.add(new RestoreAllaysTask(player, 20));
                }
            };
            TeleportTransition transition = serverPlayer.findRespawnPositionAndUseSpawnBlock(true, postTeleportTransition);
            ServerLevel targetLevel = transition.newLevel();
            Vec3 targetPos = transition.position();
            serverPlayer.teleportTo(targetLevel, targetPos.x, targetPos.y, targetPos.z, EnumSet.noneOf(Relative.class), serverPlayer.getYRot(), serverPlayer.getXRot(), true);
            transition.postTeleportTransition().onTransition((Entity)serverPlayer);
            ((ServerLevel)serverPlayer.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, targetPos.x, targetPos.y + 1.0, targetPos.z, 50, 0.5, 1.0, 0.5, 0.1);
            serverPlayer.level().playSound(null, serverPlayer.blockPosition(), SoundEvents.PORTAL_TRAVEL, SoundSource.PLAYERS);
        }
    }

    private void protectPlayer(LivingEntity player) {
        for (MobEffectInstance effect : player.getActiveEffects()) {
            if (((MobEffect)effect.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) continue;
            player.removeEffect(effect.getEffect());
        }
        player.clearFire();
        player.setDeltaMovement(Vec3.ZERO);
        player.fallDistance = 0.0f;
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400, 0));
        player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 40));
        player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 40));
    }

    public static void subscribeLivingDeath(ILivingDeathEventHandler handler) {
        livingDeathEventListeners.put(handler.getPosition(), handler);
    }

    public static void unsubscribeLivingDeath(ILivingDeathEventHandler handler) {
        livingDeathEventListeners.remove(handler.getPosition());
    }
}

