/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.items;

import com.pekar.angelblock.items.ModItemWithMultipleHoverText;
import com.pekar.angelblock.potions.BlockBreakerPotion;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BlockBreakerPotionItem
extends ModItemWithMultipleHoverText
implements ProjectileItem {
    public static float PROJECTILE_SHOOT_POWER = 1.0f;

    public BlockBreakerPotionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Projectile.spawnProjectileFromRotation(BlockBreakerPotion::new, (ServerLevel)serverLevel, (ItemStack)itemStack, (LivingEntity)player, (float)0.0f, (float)PROJECTILE_SHOOT_POWER, (float)1.0f);
        }
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return this.sidedSuccess(level.isClientSide());
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.utils.text.showExtendedDescription(tooltipComponents)) {
            return;
        }
        for (int i = 0; i <= 20; ++i) {
            tooltipComponents.add((Component)this.getDescription(i, i == 1 || i == 12, false, false, false, i == 20));
        }
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        return new BlockBreakerPotion(position.x(), position.y(), position.z(), level, itemStack);
    }
}

