/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.network.packets;

import com.pekar.angelblock.network.ClientToServerPacket;
import com.pekar.angelblock.network.Packet;
import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.IModTool;
import com.pekar.angelblock.tools.ModSword;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ToolsModeChangePacket
extends ClientToServerPacket {
    @Override
    public void onReceive(ServerPlayer player) {
        IModTool tool;
        boolean isAdvancedModeActive = player.hasEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT);
        boolean isSwordExplosionModeActive = player.hasEffect(PotionRegistry.SWORD_EXPLOSION_MODE_EFFECT);
        boolean isSwordFireModeActive = player.hasEffect(PotionRegistry.SWORD_FIRE_MODE_EFFECT);
        boolean isSwordWebModeActive = player.hasEffect(PotionRegistry.SWORD_WEB_MODE_EFFECT);
        boolean isRodMagneticModeActive = player.hasEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT);
        ItemStack mainHandItemStack = player.getMainHandItem();
        Item heldItem = mainHandItemStack.getItem();
        if (heldItem instanceof IModTool && !(tool = (IModTool)heldItem).hasCriticalDamage(mainHandItemStack)) {
            if (tool.isTool() && tool.isEnhanced()) {
                if (!isAdvancedModeActive) {
                    MobEffectInstance effect = new MobEffectInstance(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT, -1, 0, true, false, true);
                    player.addEffect(effect);
                } else {
                    player.removeEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT);
                }
                return;
            }
            if (tool.isWeapon()) {
                ModSword sword = (ModSword)tool;
                if (isSwordWebModeActive) {
                    player.removeEffect(PotionRegistry.SWORD_WEB_MODE_EFFECT);
                    if (sword.hasExplosionMode()) {
                        MobEffectInstance effect = new MobEffectInstance(PotionRegistry.SWORD_EXPLOSION_MODE_EFFECT, -1, 0, true, false, true);
                        player.addEffect(effect);
                    }
                } else if (isSwordExplosionModeActive) {
                    player.removeEffect(PotionRegistry.SWORD_EXPLOSION_MODE_EFFECT);
                    if (sword.hasFireMode()) {
                        MobEffectInstance effect = new MobEffectInstance(PotionRegistry.SWORD_FIRE_MODE_EFFECT, -1, 0, true, false, true);
                        player.addEffect(effect);
                    }
                } else if (isSwordFireModeActive) {
                    player.removeEffect(PotionRegistry.SWORD_FIRE_MODE_EFFECT);
                } else if (sword.hasWebMode()) {
                    MobEffectInstance effect = new MobEffectInstance(PotionRegistry.SWORD_WEB_MODE_EFFECT, -1, 0, true, false, true);
                    player.addEffect(effect);
                } else if (sword.hasExplosionMode()) {
                    MobEffectInstance effect = new MobEffectInstance(PotionRegistry.SWORD_EXPLOSION_MODE_EFFECT, -1, 0, true, false, true);
                    player.addEffect(effect);
                } else if (sword.hasFireMode()) {
                    MobEffectInstance effect = new MobEffectInstance(PotionRegistry.SWORD_FIRE_MODE_EFFECT, -1, 0, true, false, true);
                    player.addEffect(effect);
                }
                return;
            }
            if (tool.isRod() && tool.isEnhanced()) {
                if (!isRodMagneticModeActive) {
                    MobEffectInstance effect = new MobEffectInstance(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT, -1, 0, true, false, true);
                    player.addEffect(effect);
                } else {
                    player.removeEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT);
                }
                return;
            }
        }
        if (isAdvancedModeActive) {
            player.removeEffect(PotionRegistry.TOOL_ADVANCED_MODE_EFFECT);
        }
        if (isSwordExplosionModeActive) {
            player.removeEffect(PotionRegistry.SWORD_EXPLOSION_MODE_EFFECT);
        }
        if (isSwordFireModeActive) {
            player.removeEffect(PotionRegistry.SWORD_FIRE_MODE_EFFECT);
        }
        if (isSwordWebModeActive) {
            player.removeEffect(PotionRegistry.SWORD_WEB_MODE_EFFECT);
        }
        if (isRodMagneticModeActive) {
            player.removeEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT);
        }
    }

    @Override
    public String getPacketId() {
        return "tools_mode_change";
    }

    @Override
    public Packet decode(FriendlyByteBuf buffer) {
        return new ToolsModeChangePacket();
    }
}

