/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.blocks.BlockRegistry;
import com.pekar.angelblock.blocks.tile_entities.AngelRodBlockEntity;
import com.pekar.angelblock.tools.EndRod;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.tools.ToolRegistry;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AngelRod
extends EndRod {
    public AngelRod(ModToolMaterial material, boolean isMagnetic, Item.Properties properties) {
        super(material, isMagnetic, properties);
    }

    private String getRodId() {
        return ToolRegistry.ANGEL_ROD.getRegisteredName();
    }

    @Override
    protected void appendPlacingBlockInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        super.appendPlacingBlockInfo(tooltipComponents, false);
    }

    @Override
    protected void appendBlockTransformInfo(List<Component> tooltipComponents, boolean selectAsNew) {
        super.appendBlockTransformInfo(tooltipComponents, false);
        for (int i = 2; i <= 5; ++i) {
            if (i == 3) continue;
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, selectAsNew, false));
        }
    }

    @Override
    protected void appendMagneticInfo(List<Component> tooltipComponents) {
        super.appendMagneticInfo(tooltipComponents);
    }

    @Override
    protected void appendCommonPostInfo(List<Component> tooltipComponents) {
        for (int i = 7; i <= 8; ++i) {
            tooltipComponents.add((Component)this.getDescription(this.getRodId(), i, false, false, false, false, false, i == 7));
        }
    }

    @Override
    protected InteractionResult useOnInternal(UseOnContext context) {
        ItemStack itemStack;
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        Direction facing = context.getClickedFace();
        ItemStack mainHandItemStack = player.getMainHandItem();
        ItemStack offHandItemStack = player.getOffhandItem();
        InteractionHand hand = !mainHandItemStack.isEmpty() && mainHandItemStack.getItem() == this ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack itemStack2 = itemStack = hand == InteractionHand.MAIN_HAND ? mainHandItemStack : offHandItemStack;
        if (player.isShiftKeyDown() && blockState.isSolidRender() && facing == Direction.UP && level.isEmptyBlock(pos.above())) {
            boolean isClientSide = level.isClientSide();
            if (!isClientSide) {
                Block blockToSet = (Block)BlockRegistry.ANGEL_ROD_BLOCK.get();
                BlockState state = blockToSet.getStateForPlacement(new BlockPlaceContext(context));
                BlockState stateToSet = state != null ? state : blockToSet.defaultBlockState();
                level.setBlock(pos.above(), stateToSet, 11);
                BlockEntity blockEntity = level.getBlockEntity(pos.above());
                if (blockEntity instanceof AngelRodBlockEntity) {
                    AngelRodBlockEntity angelRodBlockEntity = (AngelRodBlockEntity)blockEntity;
                    angelRodBlockEntity.setDamage(this.getDamage(itemStack));
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos.above(), itemStack);
                }
            }
            this.utils.sound.playSoundByBlock(player, pos, SoundEvents.STONE_PLACE);
            int itemCount = itemStack.getCount();
            if (itemCount > 0) {
                itemStack.setCount(itemCount - 1);
            }
            return this.getToolInteractionResult(true, isClientSide);
        }
        return super.useOnInternal(context);
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }
}

