/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.tools;

import com.pekar.angelblock.potions.PotionRegistry;
import com.pekar.angelblock.tools.DetectorFlags;
import com.pekar.angelblock.tools.ModRod;
import com.pekar.angelblock.tools.ModToolMaterial;
import com.pekar.angelblock.utils.SoundType;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;

public class MagneticRod
extends ModRod {
    public MagneticRod(ModToolMaterial material, boolean isMagnetic, Item.Properties properties) {
        super(material, isMagnetic, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result = this.useOnInternal(context);
        if (result == InteractionResult.PASS) {
            return InteractionResult.FAIL;
        }
        if (!(result != InteractionResult.SUCCESS && result != InteractionResult.SUCCESS_SERVER || context.getLevel().isClientSide())) {
            Player player = context.getPlayer();
            this.causePlayerExhaustion(player);
        }
        return result;
    }

    protected InteractionResult useOnInternal(UseOnContext context) {
        Player player = context.getPlayer();
        ItemStack itemStack = player.getItemInHand(context.getHand());
        if (this.hasCriticalDamage(itemStack)) {
            return InteractionResult.FAIL;
        }
        if (!this.isEnhanced() || !player.hasEffect(PotionRegistry.ROD_MAGNETIC_MODE_EFFECT)) {
            return super.useOn(context);
        }
        Level level = player.level();
        boolean isClientSide = level.isClientSide();
        BlockPos pos = context.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        if (blockState.isAir() || this.utils.blocks.types.isLiquid(blockState.getBlock())) {
            return InteractionResult.FAIL;
        }
        boolean shifted = this.shiftOres(player, level, pos, context.getClickedFace());
        return shifted ? this.getToolInteractionResult(shifted, isClientSide) : InteractionResult.FAIL;
    }

    private boolean shiftOres(Player player, Level level, BlockPos pos, Direction clickedFace) {
        int initialDepth;
        TriFunction createPos;
        Function<BlockPos, Integer> getRadiusCoord2;
        Function<BlockPos, Integer> getRadiusCoord1;
        Function<BlockPos, Integer> getDepthCoord;
        int depth = Math.max(this.getSculkDetectionDepth(), Math.max(this.getAmethystDetectionDepth(), this.getOreDepth()));
        if (clickedFace == Direction.UP || clickedFace == Direction.DOWN) {
            getDepthCoord = p -> p.getY();
            getRadiusCoord1 = p -> p.getX();
            getRadiusCoord2 = p -> p.getZ();
            createPos = (x1, x2, d) -> new BlockPos(x1.intValue(), d.intValue(), x2.intValue());
            initialDepth = clickedFace == Direction.UP ? depth : -depth;
        } else if (clickedFace == Direction.SOUTH || clickedFace == Direction.NORTH) {
            getDepthCoord = p -> p.getZ();
            getRadiusCoord1 = p -> p.getX();
            getRadiusCoord2 = p -> p.getY();
            createPos = (x1, x2, d) -> new BlockPos(x1.intValue(), x2.intValue(), d.intValue());
            initialDepth = clickedFace == Direction.SOUTH ? depth : -depth;
        } else {
            getDepthCoord = p -> p.getX();
            getRadiusCoord1 = p -> p.getY();
            getRadiusCoord2 = p -> p.getZ();
            createPos = (x1, x2, d) -> new BlockPos(d.intValue(), x1.intValue(), x2.intValue());
            initialDepth = clickedFace == Direction.EAST ? depth : -depth;
        }
        return this.shiftOreBlocks(player, level, pos, clickedFace, initialDepth, getDepthCoord, getRadiusCoord1, getRadiusCoord2, (TriFunction<Integer, Integer, Integer, BlockPos>)createPos);
    }

    private boolean shiftOreBlocks(Player player, Level level, BlockPos pos, Direction clickedFace, int initialDepth, Function<BlockPos, Integer> getDepthCoord, Function<BlockPos, Integer> getRadiusCoord1, Function<BlockPos, Integer> getRadiusCoord2, TriFunction<Integer, Integer, Integer, BlockPos> createPos) {
        int radius = this.getShiftingRadius();
        boolean isDiamondOreFound = false;
        boolean isShiftingOreFound = false;
        boolean isAmethystFound = false;
        boolean areRailsFound = false;
        boolean isSculkVeinFound = false;
        int maxDepthCoord = getDepthCoord.apply(pos) - initialDepth;
        int oreDepthCoord = getDepthCoord.apply(pos) - (initialDepth >= 0 ? this.getOreDepth() : -this.getOreDepth());
        int amethystDepthCoord = getDepthCoord.apply(pos) - (initialDepth >= 0 ? this.getAmethystDetectionDepth() : -this.getAmethystDetectionDepth());
        int railDepthCoord = getDepthCoord.apply(pos) - (initialDepth >= 0 ? this.getRailsDetectionDepth() : -this.getRailsDetectionDepth());
        int sculkDepthCoord = getDepthCoord.apply(pos) - (initialDepth >= 0 ? this.getSculkDetectionDepth() : -this.getSculkDetectionDepth());
        boolean shifted = false;
        for (int x1 = getRadiusCoord1.apply(pos) - radius; x1 <= getRadiusCoord1.apply(pos) + radius; ++x1) {
            block1: for (int x2 = getRadiusCoord2.apply(pos) - radius; x2 <= getRadiusCoord2.apply(pos) + radius; ++x2) {
                BlockPos currentPos = (BlockPos)createPos.apply((Object)x1, (Object)x2, (Object)maxDepthCoord);
                while (!Objects.equals(getDepthCoord.apply(currentPos), getDepthCoord.apply(pos))) {
                    BlockPos replacedPos;
                    boolean doCurrentDepthAllowDetectSculk;
                    boolean doCurrentDepthAllowDetectRails;
                    boolean doCurrentDepthAllowDetectAmethyst;
                    boolean doCurrentDepthAllowShiftOres;
                    Integer currentDepth = getDepthCoord.apply(currentPos);
                    if (initialDepth >= 0) {
                        doCurrentDepthAllowShiftOres = currentDepth >= oreDepthCoord;
                        doCurrentDepthAllowDetectAmethyst = currentDepth >= amethystDepthCoord;
                        doCurrentDepthAllowDetectRails = currentDepth >= railDepthCoord;
                        doCurrentDepthAllowDetectSculk = currentDepth >= sculkDepthCoord;
                    } else {
                        doCurrentDepthAllowShiftOres = currentDepth <= oreDepthCoord;
                        doCurrentDepthAllowDetectAmethyst = currentDepth <= amethystDepthCoord;
                        doCurrentDepthAllowDetectRails = currentDepth <= railDepthCoord;
                        doCurrentDepthAllowDetectSculk = currentDepth <= sculkDepthCoord;
                    }
                    Block currentBlock = level.getBlockState(currentPos).getBlock();
                    boolean isDiamondOre = this.utils.blocks.types.isDiamondOre(currentBlock);
                    boolean isShiftingOre = this.isShiftingOre(level, currentPos);
                    boolean isAmethystGeode = this.isAmethystGeode(currentBlock);
                    boolean isRail = this.utils.blocks.types.isRail(currentBlock);
                    boolean isSculkVein = this.utils.blocks.types.isSculk(currentBlock);
                    if (doCurrentDepthAllowDetectAmethyst && isAmethystGeode) {
                        isAmethystFound = true;
                    }
                    if (doCurrentDepthAllowDetectRails && isRail) {
                        areRailsFound = true;
                    }
                    if (doCurrentDepthAllowDetectSculk && isSculkVein) {
                        isSculkVeinFound = true;
                    }
                    if (!doCurrentDepthAllowShiftOres) {
                        replacedPos = currentPos.relative(clickedFace);
                    } else {
                        if (isDiamondOre) {
                            isDiamondOreFound = true;
                        }
                        if (!isShiftingOre) {
                            replacedPos = currentPos.relative(clickedFace);
                        } else {
                            isShiftingOreFound = true;
                            boolean solidBlockFound = false;
                            replacedPos = currentPos.relative(clickedFace);
                            while (!Objects.equals(getDepthCoord.apply(replacedPos), getDepthCoord.apply(pos.relative(clickedFace)))) {
                                BlockState blockState = level.getBlockState(replacedPos);
                                if (!blockState.isAir() && !this.utils.blocks.types.isLiquid(blockState.getBlock())) {
                                    solidBlockFound = true;
                                    break;
                                }
                                replacedPos = replacedPos.relative(clickedFace);
                            }
                            if (!solidBlockFound) continue block1;
                            boolean result = this.tryExchange(level, currentPos, replacedPos);
                            if (result) {
                                shifted = true;
                            }
                        }
                    }
                    currentPos = replacedPos;
                }
            }
        }
        if (shifted || isDiamondOreFound || isAmethystFound || areRailsFound || isSculkVeinFound) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.oreFoundEvent(serverPlayer, pos, new DetectorFlags(shifted, isDiamondOreFound, isAmethystFound, areRailsFound, isSculkVeinFound));
            }
            return shifted;
        }
        return false;
    }

    protected void oreFoundEvent(ServerPlayer player, BlockPos pos, DetectorFlags detectorFlags) {
        if (detectorFlags.isShiftingOreFound()) {
            this.utils.sound.playSoundOnBothSides(player, pos, SoundType.ORE_FOUND, SoundSource.BLOCKS, 5.0f);
        }
    }

    private boolean tryExchange(Level level, BlockPos currentPos, BlockPos closerPos) {
        if (!this.isShiftingOre(level, currentPos)) {
            return false;
        }
        if (!this.canBeReplaced(level, closerPos)) {
            return false;
        }
        if (!level.isClientSide()) {
            this.exchange(level, currentPos, closerPos);
        }
        return true;
    }

    protected int getShiftingRadius() {
        return 1;
    }

    protected int getOreDepth() {
        return 5;
    }

    protected int getAmethystDetectionDepth() {
        return 20;
    }

    protected int getRailsDetectionDepth() {
        return 64;
    }

    protected int getSculkDetectionDepth() {
        return 64;
    }

    private void exchange(Level level, BlockPos currentPos, BlockPos closerPos) {
        BlockState currentBlockState = level.getBlockState(currentPos);
        BlockState upperBlockState = level.getBlockState(closerPos);
        level.setBlock(currentPos, upperBlockState, 3);
        level.setBlock(closerPos, currentBlockState, 3);
    }

    protected boolean canBeReplaced(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        TagKey replaceables = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"overworld_replaceables"));
        return blockState.is(replaceables);
    }

    protected boolean isShiftingOre(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        TagKey shiftingOres = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"angelblock", (String)"overworld_shifting_ores"));
        return blockState.is(shiftingOres);
    }

    private boolean isAmethystGeode(Block block) {
        return block == Blocks.SMOOTH_BASALT || block == Blocks.CALCITE;
    }
}

