/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lootpatched.impl.modifier;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lootpatched.api.LootModifier;
import dev.worldgen.lootpatched.impl.mixin.LootTableAccessor;
import dev.worldgen.lootpatched.impl.modifier.CommonData;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;

public record ApplyFunction(CommonData commonData, LootItemFunction function) implements LootModifier
{
    public static final MapCodec<ApplyFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CommonData.codec(2000).forGetter(ApplyFunction::commonData), (App)LootItemFunctions.ROOT_CODEC.fieldOf("function").forGetter(ApplyFunction::function)).apply((Applicative)instance, ApplyFunction::new));

    @Override
    public void apply(LootTable table, ResourceLocation key) {
        LootTableAccessor accessor = this.accessor(table);
        ImmutableList fullFunctions = ImmutableList.builder().addAll(accessor.lootpatched$getFunctions()).add((Object)this.function).build();
        accessor.lootpatched$setFunctions((List<LootItemFunction>)fullFunctions);
        accessor.lootpatched$setCompositeFunction(LootItemFunctions.compose((List)fullFunctions));
    }

    @Override
    public MapCodec<? extends LootModifier> codec() {
        return CODEC;
    }
}

