/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.datapatched.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.neoforge.resource.JarContentsPackResources;
import net.neoforged.neoforgespi.language.IModInfo;

public record DatapatchedResourceSupplier(BiFunction<PackLocationInfo, String, PackResources> resourceGetter) implements Pack.ResourcesSupplier
{
    public static DatapatchedResourceSupplier create() {
        IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById("datapatched").orElseThrow(() -> new IllegalArgumentException("Mod not found: datapatched"))).getModInfo();
        BiFunction<PackLocationInfo, String, PackResources> resourceGetter = (info, prefix) -> {
            JarContents contents = modInfo.getOwningFile().getFile().getContents();
            return new JarContentsPackResources(info, contents, prefix);
        };
        return new DatapatchedResourceSupplier(resourceGetter);
    }

    public PackResources openPrimary(PackLocationInfo info) {
        return this.resourceGetter.apply(info, "trade_rebalance");
    }

    public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
        PackResources baseResources = this.resourceGetter.apply(info, "trade_rebalance");
        List overlays = metadata.overlays();
        if (overlays.isEmpty()) {
            return baseResources;
        }
        ArrayList<PackResources> effectiveOverlays = new ArrayList<PackResources>(overlays.size());
        for (String s : overlays) {
            effectiveOverlays.add(this.resourceGetter.apply(info, "trade_rebalance/" + s));
        }
        return new CompositePackResources(baseResources, effectiveOverlays);
    }
}

